/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mdstore.modular.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import eu.dnetlib.data.mdstore.modular.RecordParser;
import eu.dnetlib.data.mdstore.modular.connector.MDStore;
import eu.dnetlib.data.mdstore.modular.connector.MDStoreDao;
import eu.dnetlib.data.mdstore.modular.mongodb.MongoMDStore;
import eu.dnetlib.data.mdstore.modular.mongodb.utils.MDStoreUtils;
import eu.dnetlib.miscutils.collections.FilteredCollection;
import eu.dnetlib.miscutils.collections.MappedCollection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class MDStoreDaoImpl
implements MDStoreDao {
    private static final Log log = LogFactory.getLog(MDStoreDaoImpl.class);
    private DB db;
    private RecordParser recordParser;
    private boolean upsert;
    private boolean discardRecords = true;

    public void createMDStore(String mdId, String format, String interpretation, String layout) {
        String internalId = mdId;
        if (internalId.contains("_")) {
            internalId = StringUtils.substringBefore((String)mdId, (String)"_");
        }
        this.db.createCollection(internalId, null);
        DBCollection coll = this.db.getCollection("metadata");
        BasicDBObject obj = new BasicDBObject();
        obj.put("mdId", (Object)mdId);
        obj.put("format", (Object)format);
        obj.put("interpretation", (Object)interpretation);
        obj.put("layout", (Object)layout);
        coll.save((DBObject)obj);
    }

    public void deleteMDStore(String mdId) {
        DBCollection coll = this.db.getCollection("metadata");
        String internalId = mdId;
        if (internalId.contains("_")) {
            internalId = StringUtils.substringBefore((String)mdId, (String)"_");
        }
        log.info((Object)("delete mdId: " + mdId));
        coll.remove((DBObject)new BasicDBObject("mdId", (Object)mdId));
        DBCollection mdColl = this.db.getCollection(internalId);
        if (mdColl != null) {
            mdColl.drop();
        }
    }

    public MDStore getMDStore(String mdId) {
        String internalId = mdId;
        if (internalId.contains("_")) {
            internalId = StringUtils.substringBefore((String)mdId, (String)"_");
        }
        return new MongoMDStore(mdId, this.db.getCollection(internalId), this.recordParser, this.isUpsert(), this.isDiscardRecords());
    }

    public List<String> listMDStores() {
        return MappedCollection.listMap((Iterable)this.db.getCollection("metadata").find(), MDStoreUtils.mdId());
    }

    public List<String> listMDStores(String format, String layout, String interpretation) {
        return MappedCollection.listMap((Iterable)FilteredCollection.listFilter((Iterable)this.getDb().getCollection("metadata").find(), MDStoreUtils.dboFilter(format, layout, interpretation)), MDStoreUtils.mdId());
    }

    public DB getDb() {
        return this.db;
    }

    @Required
    public void setDb(DB db) {
        this.db = db;
    }

    public RecordParser getRecordParser() {
        return this.recordParser;
    }

    @Required
    public void setRecordParser(RecordParser recordParser) {
        this.recordParser = recordParser;
    }

    @Required
    public void setUpsert(boolean upsert) {
        this.upsert = upsert;
    }

    public boolean isUpsert() {
        return this.upsert;
    }

    public boolean isDiscardRecords() {
        return this.discardRecords;
    }

    public void setDiscardRecords(boolean discardRecords) {
        this.discardRecords = discardRecords;
    }
}

