package eu.dnetlib.data.mdstore.modular.connector;

import eu.dnetlib.enabling.resultset.ResultSetListener;

public interface MDStore {
	String getId();

	String getFormat();

	String getInterpretation();

	String getLayout();

	void truncate();

	int feed(Iterable<String> records, boolean incremental);

	ResultSetListener deliver(String from, String until, String recordFilter);

	ResultSetListener deliverIds(String from, String until, String recordFilter);
	
	Iterable<String> iterate();

	int getSize();

	void deleteRecord(String recordId);
	
	String getRecord(String recordId);

}
