package eu.dnetlib.data.mdstore.modular;

import java.util.concurrent.Callable;

import org.springframework.beans.factory.annotation.Required;

import eu.dnetlib.data.mdstore.MDStoreServiceException;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerAction;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;

public class FeedAction extends AbstractMDStoreAction implements BlackboardServerAction<MDStoreActions> {

	private MDStoreFeeder feeder;
	
	@Override
	public void execute(final BlackboardServerHandler handler, final BlackboardJob job) throws Exception {
			
		final String mdId = job.getParameters().get("mdId");
		if (mdId == null || mdId.isEmpty()) {
			throw new MDStoreServiceException("Blackboard param (mdId) is empty");
		}
		
		final String epr = job.getParameters().get("epr");
		if (epr == null || epr.isEmpty()) {
			throw new MDStoreServiceException("Blackboard param (mdId) is empty");
		}
		
		String storingType = job.getParameters().get("storingType");
		if (storingType == null || storingType.isEmpty()) {
			storingType = "REFRESH";
		}
		
		feeder.feed(mdId, epr, storingType, true, new Callable<Object>() {
			@Override
			public Object call() {
				job.getParameters().put("total", "" + getDao().getMDStore(mdId).getSize());
				handler.done(job);
				return null;
			}
		}, new Callable<Object>() {
			@Override
			public Object call() {
				handler.failed(job, new Exception("Error during feeding of " + mdId));
				return null;
			}
		});
		
	}

	public MDStoreFeeder getFeeder() {
		return feeder;
	}

	@Required
	public void setFeeder(MDStoreFeeder feeder) {
		this.feeder = feeder;
	}

}
