package eu.dnetlib.data.mdstore.modular;

import org.springframework.beans.factory.annotation.Required;

import eu.dnetlib.enabling.is.registry.rmi.ISRegistryException;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerAction;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;

public class CreateAction extends AbstractMDStoreAction implements BlackboardServerAction<MDStoreActions> {

	private MDStoreProfileCreator profileCreator;
	
	@Override
	public void execute(final BlackboardServerHandler handler, final BlackboardJob job) throws ISRegistryException {		
		final String format = job.getParameters().get("format");
		final String interpretation = job.getParameters().get("interpretation");
		final String layout = job.getParameters().get("layout");
		
		final String mdId = profileCreator.registerProfile(format, interpretation, layout);
		
		getDao().createMDStore(mdId, format, interpretation, layout);
		
		job.getParameters().put("id", mdId);
		
		handler.done(job);
	}

	public MDStoreProfileCreator getProfileCreator() {
		return profileCreator;
	}

	@Required
	public void setProfileCreator(final MDStoreProfileCreator profileCreator) {
		this.profileCreator = profileCreator;
	}

}
