package eu.dnetlib.enabling.database.utils;

import javax.sql.DataSource;

import org.springframework.beans.factory.annotation.Required;
import org.springframework.jdbc.core.JdbcTemplate;

import eu.dnetlib.enabling.database.DataSourceFactory;

public class JdbcTemplateFactory {
	private DataSourceFactory dataSourceFactory;
	
	public JdbcTemplate createJdbcTemplate(String db) {
		return new JdbcTemplate(dataSourceFactory.createDataSource(db));
	}
	
	public JdbcTemplate createJdbcTemplate(DataSource dataSource) {
		return new JdbcTemplate(dataSource);
	}

	@Required
	public void setDataSourceFactory(DataSourceFactory dataSourceFactory) {
		this.dataSourceFactory = dataSourceFactory;
	}

}
