/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.information.publisher;

import com.google.common.base.Joiner;
import eu.dnetlib.data.information.publisher.rmi.PublisherService;
import eu.dnetlib.data.provision.index.rmi.IndexService;
import eu.dnetlib.data.provision.index.rmi.IndexServiceException;
import eu.dnetlib.enabling.resultset.rmi.ResultSetException;
import eu.dnetlib.enabling.resultset.rmi.ResultSetService;
import eu.dnetlib.enabling.tools.AbstractBaseService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.enabling.tools.ServiceResolver;
import eu.dnetlib.miscutils.collections.MappedCollection;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class PublisherServiceImpl
extends AbstractBaseService
implements PublisherService {
    private static final Log log = LogFactory.getLog(PublisherServiceImpl.class);
    private ServiceLocator<IndexService> indexLocator;
    private ServiceResolver serviceResolver;

    public String getResourceById(String id, String format, String layout, String interpretation) {
        try {
            W3CEndpointReference epr = ((IndexService)this.indexLocator.getService()).lookup("objIdentifier=\"" + id + "\"", format, layout, interpretation);
            ResultSetService resultSet = (ResultSetService)this.serviceResolver.getService(ResultSetService.class, epr);
            String rsId = this.serviceResolver.getResourceIdentifier(epr);
            if (resultSet.getNumberOfElements(rsId) > 0) {
                try {
                    return this.unwrap((String)resultSet.getResult(rsId, 1, 1, "waiting").get(0));
                }
                catch (TransformerFactoryConfigurationError e) {
                    log.warn((Object)"transformer factory configuration", (Throwable)e);
                    return null;
                }
                catch (TransformerException e) {
                    log.warn((Object)"transformer exception", (Throwable)e);
                    return null;
                }
            }
        }
        catch (IndexServiceException e) {
            log.warn((Object)("cannot find record for id " + id + " and format " + format + "and layout " + layout + " and interpretation " + interpretation), (Throwable)e);
            return null;
        }
        catch (ResultSetException e) {
            log.warn((Object)("cannot fetch record for id " + id + " and format " + format + "and layout " + layout + " and interpretation " + interpretation), (Throwable)e);
            return null;
        }
        log.warn((Object)("no matching record for id " + id + " and format " + format + "and layout " + layout + " and interpretation " + interpretation));
        return null;
    }

    public W3CEndpointReference getResourcesByIds(List<String> ids, String format, String layout, String interpretation) {
        String query = Joiner.on((String)" or ").join((Iterable)new MappedCollection(ids, (UnaryFunction)new UnaryFunction<String, String>(){

            public String evaluate(String id) {
                return "objidentifier=\"" + id + "\"";
            }
        }));
        try {
            return this.unwrapResultSet(((IndexService)this.indexLocator.getService()).lookup(query, format, layout, interpretation));
        }
        catch (IndexServiceException e) {
            log.warn((Object)("cannot fetch record for ids " + ids + " and format " + format), (Throwable)e);
            return null;
        }
    }

    public W3CEndpointReference unwrapResultSet(W3CEndpointReference indexLookup) {
        return indexLookup;
    }

    public String unwrap(String source) throws TransformerFactoryConfigurationError, TransformerException {
        StringWriter result = new StringWriter();
        Transformer transformer = TransformerFactory.newInstance().newTransformer(new StreamSource(((Object)((Object)this)).getClass().getResourceAsStream("unwrap.xsl")));
        transformer.transform(new StreamSource(new StringReader(source)), new StreamResult(result));
        return result.toString();
    }

    public ServiceLocator<IndexService> getIndexLocator() {
        return this.indexLocator;
    }

    @Required
    public void setIndexLocator(ServiceLocator<IndexService> indexLocator) {
        this.indexLocator = indexLocator;
    }

    public ServiceResolver getServiceResolver() {
        return this.serviceResolver;
    }

    @Required
    public void setServiceResolver(ServiceResolver serviceResolver) {
        this.serviceResolver = serviceResolver;
    }
}

