<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:datetime="http://exslt.org/dates-and-times" xmlns:exslt="http://exslt.org/common"
	xmlns:oai="http://www.openarchives.org/OAI/2.0/"
	xmlns:dnet="eu.dnetlib.data.transform.xml.DataciteToHbaseXsltFunctions"
	xmlns:oaf="http://namespace.openaire.eu/oaf"
	exclude-result-prefixes="xsl datetime exslt xsi dnet" xmlns:dri="http://www.driver-repository.eu/namespace/dri"
	xmlns:dr="http://www.driver-repository.eu/namespace/dr">



	<xsl:param name="repoId" />
	<xsl:param name="storeId" />
	<xsl:param name="namespacePrefix"/>
	<xsl:param name="dateOfCollection"/>

	<xsl:template match="oai:header">
		<xsl:variable name="dummy">
			<xsl:element name="dri:dummy"
				namespace="http://www.driver-repository.eu/namespace/dri" />
		</xsl:variable>
		<header>
<!--			<xsl:copy-of select="exslt:node-set($dummy)//namespace::*" />-->

			<dri:objIdentifier>
				<xsl:value-of select="$namespacePrefix" />::<xsl:value-of select="dnet:md5(./oai:identifier)" />
			</dri:objIdentifier>
<!-- 			<dri:objIdentifier> -->
<!-- 				<xsl:value-of select="$repoId" />::<xsl:value-of select="./oai:identifier" /> -->
<!-- 			</dri:objIdentifier> -->
			<dri:recordIdentifier>
<!-- 				<xsl:value-of select="$storeId" />:: --><xsl:value-of select="./oai:identifier" />
			</dri:recordIdentifier>
			<dri:dateOfCollection>
				<xsl:value-of select="$dateOfCollection" />
			</dri:dateOfCollection>
			<dr:dateOfCollection>
				<xsl:value-of select="$dateOfCollection" />
			</dr:dateOfCollection>
			<dri:repositoryId>
				<xsl:value-of select="$repoId" />
			</dri:repositoryId>
			<oaf:datasourceprefix><xsl:value-of select="$namespacePrefix" /></oaf:datasourceprefix>
			<xsl:apply-templates />
		</header>
	</xsl:template>

	<xsl:template match="oai:*">
		<xsl:element name="{local-name()}">
			<xsl:apply-templates select="@*|*|text()" />
		</xsl:element>
	</xsl:template>

	<xsl:template match="@*|*">
		<xsl:copy>
			<xsl:apply-templates select="@*|*|text()" />
		</xsl:copy>
	</xsl:template>

</xsl:stylesheet>