 <NODE name="SET_INFO" isStart="true" type="SetProviderInfo">
	<DESCRIPTION>Set information about current provider</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="providerId" managedBy="system">$params.("dataprovider:id")$</PARAM>
		<PARAM required="true" type="string" name="providerName" managedBy="system">$params.("dataprovider:name")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="fetchOriginals"/>		
	</ARCS>
</NODE>

<NODE name="fetchOriginals" type="FetchMDStoreRecords">
	<DESCRIPTION>Fetch records from MDStore</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="mdId" managedBy="user"></PARAM>
		<PARAM required="true" type="string" name="mdFormat" managedBy="system">OAF</PARAM>
		<PARAM required="true" type="string" name="eprParam" managedBy="system">tran_epr</PARAM>	
	</PARAMETERS>
	<ARCS>
		<ARC to="RETRIEVEURL"/>
	</ARCS>
</NODE>

<NODE name="RETRIEVEURL" type="RetrieveURL">
	<DESCRIPTION>Retrieve urls from mdstore</DESCRIPTION>
	<PARAMETERS>			
		<PARAM required="true" type="string" name="inputEprParam" managedBy="system">tran_epr</PARAM>
		<PARAM required="true" type="string" name="outputEprParam" managedBy="system">url_epr</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="CHECKNEWOBJECTS"/>
	</ARCS>
</NODE>


<NODE name="CHECKNEWOBJECTS" type="CheckNewItemToDownload">
	<DESCRIPTION>Check new Item to download</DESCRIPTION>
	<PARAMETERS>	
		<PARAM required="true" managedBy="system" type="string" name="objectStoreId">$params.("objs_id")$</PARAM>
		<PARAM required="true" managedBy="system" type="string" name="contentDescription">pdf</PARAM>
		<PARAM required="true" type="string" name="inputEprParam" managedBy="system">url_epr</PARAM>
		<PARAM required="true" type="string" name="outputEprParam" managedBy="system">download_epr</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="DOWNLOAD"/>
	</ARCS>	
</NODE>

<NODE name="DOWNLOAD" type="DownloadFromMetadata">
	<DESCRIPTION>Download new Item </DESCRIPTION>
	<PARAMETERS>	
		<PARAM required="true" managedBy="system" type="string" name="objectStoreId">$params.("objs_id")$</PARAM>
		<PARAM required="true" type="string" name="inputEprParam" managedBy="system">download_epr</PARAM>
		<PARAM required="true" managedBy="system" type="string" name="contentDescription">pdf</PARAM>		
	</PARAMETERS>
	<ARCS>
		<ARC to="success"/>
	</ARCS>	
</NODE>

