package eu.dnetlib.msro.openaireplus.workflows.nodes.repohi;

import java.io.StringReader;

import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Required;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.util.WorkflowsConstants;

public class RetrieveInterfaceInfoJobNode extends SimpleJobNode {

	private ServiceLocator<ISLookUpService> lookupLocator;

	@Override
	protected String execute(final NodeToken token) throws Exception {

		String datasourceId = token.getFullEnv().getAttribute(WorkflowsConstants.DATAPROVIDER_ID);
		String interfaceID = token.getFullEnv().getAttribute(WorkflowsConstants.DATAPROVIDER_INTERFACE);
		final String profile = lookupLocator.getService().getResourceProfile(datasourceId);
		final Document doc = (new SAXReader()).read(new StringReader(profile));
		final Node ifcNode = doc.selectSingleNode("//INTERFACE[@id='" + interfaceID + "']");

		String contentDescription = ifcNode.valueOf("./@contentDescription");
		token.getEnv().setAttribute("objectStoreContentDescription", contentDescription);

		return Arc.DEFAULT_ARC;
	}

	@Required
	public void setLookupLocator(final ServiceLocator<ISLookUpService> lookupLocator) {
		this.lookupLocator = lookupLocator;
	}

	public ServiceLocator<ISLookUpService> getLookupLocator() {
		return lookupLocator;
	}
}
