package eu.dnetlib.msro.openaireplus.workflows.nodes.index;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.functionality.index.solr.feed.InputDocumentFactory;
import eu.dnetlib.functionality.index.solr.feed.SolrServerPool;
import eu.dnetlib.msro.workflows.nodes.AsyncJobNode;

public class FinalizeIndexJobNode extends AsyncJobNode {

	private static final Log log = LogFactory.getLog(FinalizeIndexJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Override
	protected String execute(NodeToken token) throws Exception {

		final String version = token.getEnv().getAttribute("index.feed.timestamp");

		final SolrServerPool serverPool = new SolrServerPool(token.getEnv().getAttribute("index.solr.url.local"), token.getEnv().getAttribute(
				"index.solr.url.list"), token.getEnv().getAttribute("index.solr.url.zk"), token.getEnv().getAttribute("index.solr.collection"),
				Boolean.parseBoolean(token.getEnv().getAttribute("index.solr.local.feeding")));

		final String query = "__dsversion:{* TO " + InputDocumentFactory.getParsedDateField(version) + "}";

		log.info("DELETE BY QUERY: " + query);
		serverPool.deleteByQuery(query);

		log.info("INDEX COMMIT...");
		serverPool.commitAll();
		log.info("INDEX COMMIT DONE!");

		return Arc.DEFAULT_ARC;
	}

}
