package eu.dnetlib.msro.openaireplus.workflows.nodes.hbase;

import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.google.common.collect.Iterables;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.data.hadoop.rmi.HadoopBlackboardActions;
import eu.dnetlib.data.hadoop.rmi.HadoopJobType;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;

public class SubmitHadoopJobNode extends BlackboardJobNode {

	/**
	 * logger.
	 */
	private static final Log log = LogFactory.getLog(SubmitHadoopJobNode.class);

	@Resource(name = "lookupLocator")
	private ServiceLocator<ISLookUpService> lookupLocator;

	private String hadoopJob;

	private String cluster;

	@Override
	protected String getXqueryForServiceId(final NodeToken token) {
		return "collection('/db/DRIVER/ServiceResources/HadoopServiceResourceType')//RESOURCE_IDENTIFIER/@value/string()";
	}

	@Override
	protected void prepareJob(final BlackboardJob job, final NodeToken token) throws Exception {
		String type = getJobType(getHadoopJob());

		log.info("submitting job " + getHadoopJob() + " type: " + type);

		job.setAction(type);
		job.getParameters().put("job.name", getHadoopJob());
		job.getParameters().put("cluster", getCluster());

		job.getParameters().putAll(parseJsonParameters(token));
	}

	/**
	 * reads the job type for the given job name
	 * 
	 * @param jobName
	 * @return
	 * @throws ISLookUpException
	 */
	private String getJobType(String jobName) throws ISLookUpException {
		List<String> res = lookupLocator.getService().quickSearchProfile(
				"/RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'HadoopJobConfigurationDSResourceType']//HADOOP_JOB[./@name='" + jobName + "']/@type/string()");
		if (res.isEmpty()) { throw new IllegalStateException("unable to find job type for job: " + jobName); }

		final HadoopJobType type = HadoopJobType.valueOf(Iterables.getOnlyElement(res));

		switch (type) {
		case mapreduce:
			return HadoopBlackboardActions.SUBMIT_MAPREDUCE_JOB.toString();
		case oozie:
			return HadoopBlackboardActions.SUBMIT_OOZIE_JOB.toString();
		default:
			throw new IllegalStateException("undefined job type: " + type.toString());
		}
	}

	public String getHadoopJob() {
		return hadoopJob;
	}

	public void setHadoopJob(final String hadoopJob) {
		this.hadoopJob = hadoopJob;
	}

	public String getCluster() {
		return cluster;
	}

	public void setCluster(final String cluster) {
		this.cluster = cluster;
	}

}
