package eu.dnetlib.msro.openaireplus.workflows.nodes.hbase;

import java.util.Set;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.data.hadoop.rmi.HadoopService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.msro.openaireplus.workflows.hbase.HBaseTableUtils;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

public class PrepareHBaseJobNode extends SimpleJobNode {

	private String hbaseTableProperty;
	private String cluster;

	private ServiceLocator<HadoopService> hadoopServiceLocator;

	private static final Log log = LogFactory.getLog(PrepareHBaseJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Override
	protected String execute(final NodeToken token) throws Exception {
		final Set<String> columns = HBaseTableUtils.listColumns();
		final String tableName = tableName();

		log.debug("Ensuring table " + tableName + " - columns: " + columns);

		hadoopServiceLocator.getService().ensureHbaseTable(cluster, tableName, columns);

		return Arc.DEFAULT_ARC;
	}

	private String tableName() {
		return getPropertyFetcher().getProperty(getHbaseTableProperty());
	}

	public ServiceLocator<HadoopService> getHadoopServiceLocator() {
		return hadoopServiceLocator;
	}

	@Required
	public void setHadoopServiceLocator(final ServiceLocator<HadoopService> hadoopServiceLocator) {
		this.hadoopServiceLocator = hadoopServiceLocator;
	}

	public String getCluster() {
		return cluster;
	}

	public void setCluster(final String cluster) {
		this.cluster = cluster;
	}

	public String getHbaseTableProperty() {
		return hbaseTableProperty;
	}

	public void setHbaseTableProperty(String hbaseTableProperty) {
		this.hbaseTableProperty = hbaseTableProperty;
	}

}
