package eu.dnetlib.msro.openaireplus.workflows.nodes.download.plugin;

import eu.dnetlib.data.objectstore.modular.ModularObjectStoreService;
import gr.uoa.di.resourcediscovery.MethodProvider;
import gr.uoa.di.resourcediscovery.MethodProviderFileStorageImpl;
import gr.uoa.di.resourcediscovery.methods.ResourceDiscoveryMethod;
import gr.uoa.di.resourcediscovery.methods.XPathAndCrawl;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.List;

public class UOAExtractor extends ExtractorPlugin {

	private String methodMapFileStorageDir = "/tmp/";

	/**
	 * Method provider.
	 */
	private MethodProvider provider;

	public UOAExtractor(final ModularObjectStoreService objectStoreService, final String objectStoreId) {
		super(objectStoreService, objectStoreId);
		try {
			String fileName = methodMapFileStorageDir;
			if (!methodMapFileStorageDir.endsWith(File.separator)) {
				fileName += File.separator;
			}
			fileName += "method-map.xml";
			provider = new MethodProviderFileStorageImpl(fileName);
			mimeTypes = Arrays.asList(new String[] { "application/pdf" });
		} catch (Exception e) {
			log.error(e);
		}
	}

	public String getMethodMapFileStorageDir() {
		return methodMapFileStorageDir;
	}

	public void setMethodMapFileStorageDir(final String methodMapFileStorageDir) {
		this.methodMapFileStorageDir = methodMapFileStorageDir;
	}

	@Override
	public String extractUrl(final String url) {
		try {
			URL conUrl = new URL(url);
			ResourceDiscoveryMethod method = provider.getMethod(conUrl);
			if (method == null) {
				XPathAndCrawl xpath = new XPathAndCrawl(mimeTypes, null);
				method = xpath;
			}
			List<String> resources = method.getResources(conUrl, provider);
			if (resources.size() >= 1) return resources.get(0);
		} catch (Exception e) {
			log.error("unable to obtain resource from location ", e);
			return null;
		}
		return null;
	}
}
