package eu.dnetlib.msro.openaireplus.workflows.nodes.download.plugin;

import eu.dnetlib.data.objectstore.modular.ModularObjectStoreService;
import eu.dnetlib.data.objectstore.rmi.ObjectStoreFile;
import eu.dnetlib.data.objectstore.rmi.Protocols;
import eu.dnetlib.data.transform.xml.AbstractDNetOafXsltFunctions;
import eu.dnetlib.msro.openaireplus.workflows.nodes.download.LinkedObject;

public class PUMAExtractor extends ExtractorPlugin {

	public PUMAExtractor(final ModularObjectStoreService objectStoreService, final String objectStoreId) {
		super(objectStoreService, objectStoreId);
		// TODO Auto-generated constructor stub
	}

	@Override
	public String extractUrl(final String url) {
		LinkedObject object = LinkedObject.createFromJSON(url);
		for (String s : object.getURLS()) {
			if (s.endsWith(".pdf")) {
				ObjectStoreFile info = new ObjectStoreFile();
				info.setAccessProtocol(Protocols.None);
				info.setAccessProtocol(Protocols.HTTP);
				info.setObjectID(object.getObjectIdentifier() + "::" + AbstractDNetOafXsltFunctions.md5(s));
				info.setDownloadedURL(s);
				info.setMimeType("pdf");
				info.setURI(s);
				return info.toJSON();
			}
		}
		return null;
	}

}
