package eu.dnetlib.msro.openaireplus.workflows.nodes.download.plugin;

import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.google.common.base.Function;

import eu.dnetlib.data.objectstore.modular.ModularObjectStoreService;
import eu.dnetlib.msro.openaireplus.workflows.nodes.download.LinkedObject;

public abstract class ExtractorPlugin implements Function<String, String> {

	protected static final Log log = LogFactory.getLog(ExtractorPlugin.class);

	private ModularObjectStoreService objectStoreService;

	private String objectStoreId;

	public ExtractorPlugin(final ModularObjectStoreService objectStoreService, final String objectStoreId) {
		this.objectStoreService = objectStoreService;
		this.objectStoreId = objectStoreId;

	}

	protected List<String> mimeTypes;

	public List<String> getMimeTypes() {
		return mimeTypes;
	}

	public void setMimeTypes(final List<String> mimeTypes) {
		this.mimeTypes = mimeTypes;
	}

	public abstract String extractUrl(final String url);

	@Override
	public String apply(final String input) {
		LinkedObject object = LinkedObject.createFromJSON(input);
		if (!objectStoreService.existIDStartsWith(objectStoreId, object.getObjectIdentifier())) return extractUrl(input);
		return null;
	}

}
