package eu.dnetlib.msro.openaireplus.workflows.nodes.download;

import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.google.common.collect.Iterables;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.data.objectstore.modular.ModularObjectStoreService;
import eu.dnetlib.enabling.resultset.IterableResultSetFactory;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.enabling.resultset.client.utils.EPRUtils;
import eu.dnetlib.msro.openaireplus.workflows.nodes.download.plugin.ExtractorPlugin;
import eu.dnetlib.msro.openaireplus.workflows.nodes.download.plugin.PUMAExtractor;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

public class CheckNewItemToDownloadJobNode extends SimpleJobNode {

	private static final Log log = LogFactory.getLog(CheckNewItemToDownloadJobNode.class);

	private String objectStoreId;
	private String inputEprParam;
	private String outputEprParam;
	private String contentDescription;

	private ResultSetClientFactory resultSetClientFactory;

	@Resource(name = "objectStoreService")
	private ModularObjectStoreService objectStoreService;

	@Resource(name = "iterableResultSetFactory")
	private IterableResultSetFactory resultSetFactory;

	@Override
	protected String execute(final NodeToken token) throws Exception {
		log.debug("Starting node CheckNewItemToDownloadJobNode");
		final W3CEndpointReference inputEpr = (new EPRUtils()).getEpr(token.getEnv().getAttribute(inputEprParam));
		Iterable<String> input = resultSetClientFactory.getClient(inputEpr);
		int i = 0;
		int total = 0;
		ExtractorPlugin extractor = new PUMAExtractor(objectStoreService, objectStoreId);

		Iterable<String> output = Iterables.transform(input, extractor);
		W3CEndpointReference eprUrls = resultSetFactory.createIterableResultSet(output);
		token.getEnv().setAttribute(outputEprParam, eprUrls.toString());

		System.out.println("Not found " + i + " over" + total);
		return Arc.DEFAULT_ARC;
	}

	// SETTER AND GETTER SECTION

	public String getInputEprParam() {
		return inputEprParam;
	}

	public void setInputEprParam(final String inputEprParam) {
		this.inputEprParam = inputEprParam;
	}

	public String getOutputEprParam() {
		return outputEprParam;
	}

	public void setOutputEprParam(final String outputEprParam) {
		this.outputEprParam = outputEprParam;
	}

	public ResultSetClientFactory getResultSetClientFactory() {
		return resultSetClientFactory;
	}

	public void setResultSetClientFactory(final ResultSetClientFactory resultSetClientFactory) {
		this.resultSetClientFactory = resultSetClientFactory;
	}

	public IterableResultSetFactory getResultSetFactory() {
		return resultSetFactory;
	}

	public void setResultSetFactory(final IterableResultSetFactory resultSetFactory) {
		this.resultSetFactory = resultSetFactory;
	}

	public ModularObjectStoreService getObjectStoreService() {
		return objectStoreService;
	}

	public void setObjectStoreService(final ModularObjectStoreService objectStoreService) {
		this.objectStoreService = objectStoreService;
	}

	public String getObjectStoreId() {
		return objectStoreId;
	}

	public void setObjectStoreId(final String objectStoreId) {
		this.objectStoreId = objectStoreId;
	}

	public String getContentDescription() {
		return contentDescription;
	}

	public void setContentDescription(final String contentDescription) {
		this.contentDescription = contentDescription;
	}

}
