package eu.dnetlib.msro.openaireplus.workflows.nodes.dedup;

import java.util.List;

import javax.annotation.Resource;

import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

import com.google.common.collect.Iterables;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.msro.workflows.nodes.AsyncJobNode;

public class DedupConfigurationLoaderJobNode extends AsyncJobNode {

	/**
	 * logger.
	 */
	private static final Log log = LogFactory.getLog(DedupConfigurationLoaderJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Resource
	private ServiceLocator<ISLookUpService> lookupLocator;

	private StringTemplate xqueryPace;

	private StringTemplate xqueryWf;

	private String entityType;

	@Override
	protected String execute(NodeToken token) throws Exception {

		if (getEntityType() == null || getEntityType().isEmpty()) { throw new IllegalArgumentException("missing entity type parameter"); }

		token.getEnv().setAttribute("entityType", getEntityType());
		token.getEnv().setAttribute("dedup.pace.conf", loadPaceConf(getEntityType()));
		token.getEnv().setAttribute("dedup.wf.conf", loadWfConf(getEntityType()));

		return Arc.DEFAULT_ARC;
	}

	public String loadPaceConf(String entityType) throws ISLookUpException {
		return loadConfig(getXquery(entityType, getXqueryPace()));
	}

	public String loadWfConf(String entityType) throws ISLookUpException {
		return loadConfig(getXquery(entityType, getXqueryWf()));
	}

	private String loadConfig(String xquery) throws ISLookUpException {
		log.info("loading configuration: " + xquery);
		List<String> profile = lookupLocator.getService().quickSearchProfile(xquery);

		if (profile == null || profile.isEmpty()) { throw new IllegalStateException("unable to load dedup configuration profile"); }

		String conf = Iterables.getOnlyElement(profile);
		return conf.replaceAll("\\s+", " ").trim();
	}

	// //////////

	private String getXquery(String entityType, StringTemplate template) {
		StringTemplate xquery = new StringTemplate(template.getTemplate());
		xquery.setAttribute("entityType", entityType);
		return xquery.toString();
	}

	public StringTemplate getXqueryPace() {
		return xqueryPace;
	}

	@Required
	public void setXqueryPace(StringTemplate xqueryPace) {
		this.xqueryPace = xqueryPace;
	}

	public StringTemplate getXqueryWf() {
		return xqueryWf;
	}

	@Required
	public void setXqueryWf(StringTemplate xqueryWf) {
		this.xqueryWf = xqueryWf;
	}

	public String getEntityType() {
		return entityType;
	}

	public void setEntityType(String entityType) {
		this.entityType = entityType;
	}

}
