package eu.dnetlib.msro.openaireplus.workflows.nodes;

import javax.annotation.Resource;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

public class ObtainOpenaireDataSourceParamsJobNode extends SimpleJobNode {

	private String providerId;

	@Resource(name = "lookupLocator")
	private ServiceLocator<ISLookUpService> lookupLocator;

	@Override
	protected String execute(final NodeToken token) throws Exception {
		final String query = "let $x := /*[.//RESOURCE_IDENTIFIER/@value='" + providerId + "']//EXTRA_FIELDS\n"
				+ "return concat($x/FIELD[./key='OpenAireDataSourceId']/value, ' @@@ ', $x/FIELD[./key='NamespacePrefix']/value)";

		final String[] arr = lookupLocator.getService().getResourceProfileByQuery(query).split("@@@");

		token.getEnv().setAttribute("parentDatasourceId", arr[0].trim());
		token.getEnv().setAttribute("namespacePrefix", arr[1].trim());
		token.getEnv().setAttribute("dateOfCollection", DateUtils.now_ISO8601());

		return Arc.DEFAULT_ARC;
	}

	public String getProviderId() {
		return providerId;
	}

	public void setProviderId(final String providerId) {
		this.providerId = providerId;
	}

}
