package eu.dnetlib.msro.openaireplus.workflows.hbase;

import java.util.Set;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;

import eu.dnetlib.data.proto.RelTypeProtos.RelType;
import eu.dnetlib.data.proto.TypeProtos.Type;

/**
 * Common static utility methods to manage the hbase tables
 * 
 * @author claudio
 * 
 */
public class HBaseTableUtils {

	public enum VolatileColumnFamily {
		dedup, dedupPerson, instance; // instance is here to remove the old protos

		public static boolean isVolatile(final String columnName) {
			try {
				return VolatileColumnFamily.valueOf(columnName) != null;
			} catch (Throwable e) {
				return false;
			}
		}
	}

	private static Function<Type, String> typeName = new Function<Type, String>() {

		@Override
		public String apply(final Type type) {
			return type.toString();
		}
	};

	private static Function<RelType, String> relTypeName = new Function<RelType, String>() {

		@Override
		public String apply(final RelType type) {
			return type.toString();
		}
	};

	private static Function<VolatileColumnFamily, String> extraColumnFamilyName = new Function<VolatileColumnFamily, String>() {

		@Override
		public String apply(final VolatileColumnFamily type) {
			return type.toString();
		}
	};

	public static Set<String> listColumns() {
		return Sets.newHashSet(Iterables.concat(Iterables.transform(Lists.newArrayList(Type.values()), typeName),
				Iterables.transform(Lists.newArrayList(RelType.values()), relTypeName),
				Iterables.transform(Lists.newArrayList(VolatileColumnFamily.values()), extraColumnFamilyName)));
	}

}
