/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.information.oai.publisher.conf;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import eu.dnetlib.data.information.oai.publisher.OaiPublisherRuntimeException;
import eu.dnetlib.data.information.oai.publisher.PublisherField;
import eu.dnetlib.data.information.oai.publisher.conf.AbstractOAIConfigurationReader;
import eu.dnetlib.data.information.oai.publisher.conf.OAIConfiguration;
import eu.dnetlib.data.information.oai.publisher.conf.OAIConfigurationParser;
import eu.dnetlib.data.information.oai.publisher.info.MDFInfo;
import eu.dnetlib.data.information.oai.publisher.info.SetInfo;
import java.io.IOException;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OAIConfigurationStringReader
extends AbstractOAIConfigurationReader {
    private static final Log log = LogFactory.getLog(OAIConfigurationStringReader.class);
    private OAIConfiguration oaiConfiguration;
    @Resource
    private OAIConfigurationParser configurationParser;

    public OAIConfigurationStringReader() {
        this.oaiConfiguration = null;
    }

    public OAIConfigurationStringReader(String profile) {
        this.readConfiguration(profile);
    }

    public void readConfiguration(String profile) {
        log.info((Object)"Reading OAI configuration profile");
        log.debug((Object)profile);
        try {
            this.oaiConfiguration = this.configurationParser.getConfiguration(profile);
        }
        catch (IOException e) {
            throw new OaiPublisherRuntimeException("Could not read OAI configuration profile", e);
        }
    }

    public boolean isConfigurationLoaded() {
        return this.oaiConfiguration != null;
    }

    @Override
    public List<SetInfo> getSets() {
        if (this.isConfigurationLoaded()) {
            return Lists.newArrayList(this.oaiConfiguration.getSetsMap().values());
        }
        throw new OaiPublisherRuntimeException("Configuration is not loaded");
    }

    @Override
    public List<SetInfo> getSets(final boolean onlyEnabled) {
        if (this.isConfigurationLoaded()) {
            return Lists.newArrayList((Iterable)Iterables.filter(this.oaiConfiguration.getSetsMap().values(), (Predicate)new Predicate<SetInfo>(){

                public boolean apply(SetInfo setInfo) {
                    if (onlyEnabled) {
                        return setInfo.isEnabled();
                    }
                    return true;
                }
            }));
        }
        throw new OaiPublisherRuntimeException("Configuration is not loaded");
    }

    @Override
    public List<String> getSetSpecs() {
        if (this.isConfigurationLoaded()) {
            return Lists.newArrayList(this.oaiConfiguration.getSetsMap().keySet());
        }
        throw new OaiPublisherRuntimeException("Configuration is not loaded");
    }

    @Override
    public List<String> getSetSpecs(boolean onlyEnabled) {
        if (this.isConfigurationLoaded()) {
            if (!onlyEnabled) {
                return this.getSetSpecs();
            }
            List<SetInfo> enabled = this.getSets(true);
            return Lists.newArrayList((Iterable)Iterables.transform(enabled, (Function)new Function<SetInfo, String>(){

                public String apply(SetInfo setInfo) {
                    return setInfo.getSetSpec();
                }
            }));
        }
        throw new OaiPublisherRuntimeException("Configuration is not loaded");
    }

    @Override
    public List<MDFInfo> getSourceMetadataFormats() {
        if (this.isConfigurationLoaded()) {
            return Lists.newArrayList(this.oaiConfiguration.getSourcesMDF());
        }
        throw new OaiPublisherRuntimeException("Configuration is not loaded");
    }

    @Override
    public SetInfo getSetInfo(String setSpec) {
        if (this.isConfigurationLoaded()) {
            return this.oaiConfiguration.getSetsMap().get(setSpec);
        }
        throw new OaiPublisherRuntimeException("Configuration is not loaded");
    }

    @Override
    public List<MDFInfo> getMetadataFormatInfo() {
        if (this.isConfigurationLoaded()) {
            return Lists.newArrayList(this.oaiConfiguration.getMdFormatsMap().values());
        }
        throw new OaiPublisherRuntimeException("Configuration is not loaded");
    }

    @Override
    public List<MDFInfo> getMetadataFormatInfo(final boolean onlyEnabled) {
        if (this.isConfigurationLoaded()) {
            if (!onlyEnabled) {
                return this.getMetadataFormatInfo();
            }
            return Lists.newArrayList((Iterable)Iterables.filter(this.oaiConfiguration.getMdFormatsMap().values(), (Predicate)new Predicate<MDFInfo>(){

                public boolean apply(MDFInfo mdfInfo) {
                    if (onlyEnabled) {
                        return mdfInfo.isEnabled();
                    }
                    return true;
                }
            }));
        }
        throw new OaiPublisherRuntimeException("Configuration is not loaded");
    }

    @Override
    public MDFInfo getMetadataFormatInfo(String mdPrefix) {
        if (this.isConfigurationLoaded()) {
            return this.oaiConfiguration.getMdFormatsMap().get(mdPrefix);
        }
        throw new OaiPublisherRuntimeException("Configuration is not loaded");
    }

    @Override
    public List<PublisherField> getFields() {
        if (this.isConfigurationLoaded()) {
            return this.oaiConfiguration.getFields();
        }
        throw new OaiPublisherRuntimeException("Configuration is not loaded");
    }

    @Override
    public List<PublisherField> getFields(String format, String interpretation, String layout) {
        if (this.isConfigurationLoaded()) {
            return Lists.newArrayList(this.oaiConfiguration.getFieldsFor(format, layout, interpretation));
        }
        throw new OaiPublisherRuntimeException("Configuration is not loaded");
    }

    @Override
    public List<String> getFieldNames() {
        if (this.isConfigurationLoaded()) {
            return this.oaiConfiguration.getFieldNames();
        }
        throw new OaiPublisherRuntimeException("Configuration is not loaded");
    }

    public OAIConfiguration getOaiConfiguration() {
        return this.oaiConfiguration;
    }

    public void setOaiConfiguration(OAIConfiguration oaiConfiguration) {
        this.oaiConfiguration = oaiConfiguration;
    }

    public OAIConfigurationParser getConfigurationParser() {
        return this.configurationParser;
    }

    public void setConfigurationParser(OAIConfigurationParser configurationParser) {
        this.configurationParser = configurationParser;
    }
}

