package eu.dnetlib.data.collector.plugins.oai;

import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.PriorityBlockingQueue;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

import eu.dnetlib.data.collector.rmi.CollectorServiceException;

public class OaiIterator implements Iterator<String> {

	private static final Log log = LogFactory.getLog(OaiIterator.class); // NOPMD by marko on 11/24/08 5:02 PM

	private Queue<String> queue = new PriorityBlockingQueue<String>();
	private SAXReader reader = new SAXReader();
	private HttpClient client = new HttpClient();
	private String baseUrl;
	private String token;

	public OaiIterator(final String baseUrl, final String mdFormat, final String set) {
		this.baseUrl = baseUrl;
		if ((set != null) && !set.isEmpty()) {
			token = firstPage(mdFormat, set);
		} else {
			token = firstPage(mdFormat, null);
		}
	}

	@Override
	public boolean hasNext() {
		synchronized (queue) {
			return !queue.isEmpty();
		}
	}

	@Override
	public String next() {
		synchronized (queue) {
			final String res = queue.poll();
			while (queue.isEmpty() && (token != null) && !token.isEmpty()) {
				token = otherPages(token);
			}
			return res;
		}
	}

	@Override
	public void remove() {}

	private String firstPage(final String mdFormat, final String set) {
		String url = baseUrl + "?verb=ListRecords&metadataPrefix=" + mdFormat;
		if ((set != null) && !set.isEmpty()) {
			url += "&set=" + set;
		}
		return downloadPage(url);
	}

	private String otherPages(final String resumptionToken) {
		return downloadPage(baseUrl + "?verb=ListRecords&resumptionToken=" + resumptionToken);
	}

	private String downloadPage(final String url) {
		try {
			log.info("HTTP GET: " + url);
			final HttpMethod method = new GetMethod(url);
			final int responseCode = client.executeMethod(method);
			if (HttpStatus.SC_OK != responseCode) { throw new CollectorServiceException("Error " + responseCode + " dowloading url: " + url); }

			final Document doc = reader.read(method.getResponseBodyAsStream());

			for (Object o : doc.selectNodes("//*[local-name()='ListRecords']/*[local-name()='record']")) {
				queue.add(((Node) o).asXML());
			}

			return doc.valueOf("//*[local-name()='resumptionToken']");
		} catch (Exception e) {
			throw new RuntimeException("Error obtaining records from: " + url, e);
		}
	}

}
