package eu.dnetlib.data.collector.plugins.ftp;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import eu.dnetlib.data.collector.rmi.InterfaceDescriptor;

public class FtpIterable implements Iterable<String> {

	private static final Log log = LogFactory.getLog(FtpIterable.class);

	private final boolean recursive;
	private final ItemUtility itemParam;

	private final BlockingQueue<String> queue;

	private ExecutorService producer;

	public final static Object done = new Object();

	public FtpIterable(final InterfaceDescriptor descriptor) throws URISyntaxException {

		this.recursive = Boolean.parseBoolean(descriptor.getParams().get("recursive"));
		itemParam = new ItemUtility(descriptor);
		this.producer = Executors.newSingleThreadExecutor();
		this.queue = new ArrayBlockingQueue<String>(20);
	}

	@Override
	public Iterator<String> iterator() {
		doReadFromFTP();
		return new FtpBlockingStream<String>(queue);
	}

	private void doReadFromFTP() {

		final FtpFileWalker<String> walker = new FtpFileWalker<String>(queue, null, recursive == true ? 0 : -1, itemParam, "ftp");
		producer.execute(new Runnable() {

			@Override
			public void run() {
				try {
					walker.doWalk(itemParam.getBasePath());
				} catch (IOException e) {
					throw new IllegalStateException(e);
				}
				log.info("finished to iterate under " + itemParam.getBasePath());
			}
		});
	}

}
