package eu.dnetlib.data.collector.plugins.ftp;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPFileFilter;

public class FtpFilter implements FTPFileFilter{
	String filterPattern;
	Pattern regExpPattern;
	
	public FtpFilter()
	{
		
	}	
	
	public FtpFilter(String pattern)
	{
		String transformed= pattern.replace(".", "\\.").replace("*", ".*");		
		regExpPattern= Pattern.compile(transformed);
	}	
	

	@Override
	public boolean accept(FTPFile arg0) {
		String name= arg0.getName();
		Matcher matcher= regExpPattern.matcher(name);
		boolean found = false;
        while (matcher.find()) {
             if(matcher.group().equals(name))
                	found = true;
        }	
		return found;
	}

	public String getFilterPattern() {
		return filterPattern;
	}

	public void setFilterPattern(String filterPattern) {
		this.filterPattern = filterPattern;
		String transformed= filterPattern.replace(".", "\\.").replace("*", ".*");		
		regExpPattern= Pattern.compile(transformed);		
	}
	
	
	

}
