package eu.dnetlib.data.collector.plugins.ftp;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Vector;

import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPFile;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.ChannelSftp.LsEntry;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.UserInfo;

/**
 * The Class ClientSFTPDataProvider.
 */
public class ClientSftpDataProvider implements FtpClientProvider {

	/** The Constant log. */
	private static final Log log = LogFactory.getLog(ClientSftpDataProvider.class);

	/** The session. */
	private Session session;

	/** The sftp channel. */
	private ChannelSftp sftpChannel;

	/** The port. */
	private int port;

	/** The item param. */
	private ItemUtility itemParam;

	/*
	 * (non-Javadoc)
	 * 
	 * @see eu.dnetlib.data.collective.harvest.provider.IClientProvider#connect()
	 */
	@Override
	public void connect() {
		try {
			JSch jsch = new JSch();
			port = 22;
			session = jsch.getSession(itemParam.getUsername(), itemParam.getHost(), port);
			UserSFTP muser = new UserSFTP();
			muser.setPassword(itemParam.getPassword());
			session.setUserInfo(muser);
			session.connect();
			Channel channel;
			channel = session.openChannel("sftp");
			channel.connect();
			sftpChannel = (ChannelSftp) channel;
		} catch (JSchException e) {
			e.printStackTrace();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see eu.dnetlib.data.collective.harvest.provider.IClientProvider#disconnect()
	 */
	@Override
	public void disconnect() {
		session.disconnect();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see eu.dnetlib.data.collective.harvest.provider.ftp.FTPClientProvider#changeWorkingDirectory(java.lang.String)
	 */
	@Override
	public boolean changeWorkingDirectory(final String path) {
		boolean b = false;
		try {
			sftpChannel.cd(path);
			b = true;
		} catch (SftpException e) {
			b = false;
		}
		return b;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see eu.dnetlib.data.collective.harvest.provider.ftp.FTPClientProvider#listFiles()
	 */
	@SuppressWarnings("unchecked")
	@Override
	public FTPFile[] listFiles() {
		ArrayList<FTPFile> tmp = new ArrayList<FTPFile>();
		try {
			Vector<LsEntry> v = sftpChannel.ls(sftpChannel.pwd());
			for (LsEntry obj : v) {

				if (obj.getFilename().startsWith(".") == false) {

					FTPFile afile = new FTPFile();
					afile.setName(obj.getFilename());
					SftpATTRS attributes = obj.getAttrs();
					if (attributes.isDir()) {
						afile.setType(1);
					} else {
						afile.setType(0);
					}
					tmp.add(afile);
				}

			}
		} catch (SftpException e) {
			e.printStackTrace();
		}
		FTPFile[] files = new FTPFile[tmp.size()];
		files = tmp.toArray(files);
		return files;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see eu.dnetlib.data.collective.harvest.provider.ftp.FTPClientProvider#listFiles(java.lang.String)
	 */
	@SuppressWarnings("unchecked")
	@Override
	public FTPFile[] listFiles(final String source) {
		ArrayList<FTPFile> tmp = new ArrayList<FTPFile>();
		try {
			Vector<LsEntry> v = sftpChannel.ls(source);
			for (LsEntry obj : v) {

				if (obj.getFilename().startsWith(".") == false) {

					FTPFile afile = new FTPFile();
					afile.setName(obj.getFilename());
					SftpATTRS attributes = obj.getAttrs();
					if (attributes.isDir()) {
						afile.setType(1);
					} else {
						afile.setType(0);
					}
					tmp.add(afile);
				}

			}
		} catch (SftpException e) {
			e.printStackTrace();
		}
		FTPFile[] files = new FTPFile[tmp.size()];
		files = tmp.toArray(files);
		return files;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see eu.dnetlib.data.collective.harvest.provider.ftp.FTPClientProvider#printWorkingDirectory()
	 */
	@Override
	public String printWorkingDirectory() {
		String path = null;
		try {
			path = sftpChannel.pwd();
		} catch (SftpException e) {
			e.printStackTrace();
		}
		return path;

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see eu.dnetlib.data.collective.harvest.provider.IClientProvider#retrieveFileStream(java.lang.String)
	 */
	@Override
	public String retrieveFileStream(final String remote) {
		try {
			InputStream stream = sftpChannel.get(remote);

			StringWriter writer = new StringWriter();
			IOUtils.copy(stream, writer);

			return writer.toString();

		} catch (IOException e) {
			log.error("cannot read file: " + remote, e);
			throw new RuntimeException(e);
		} catch (SftpException e) {
			log.error("cannot read file: " + remote, e);
			throw new RuntimeException(e);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see eu.dnetlib.data.collective.harvest.provider.ftp.FTPClientProvider#completePendingCommand()
	 */
	@Override
	public void completePendingCommand() throws IOException {
		// TODO Auto-generated method stub

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * eu.dnetlib.data.collective.harvest.provider.IClientProvider#setItemParam(eu.dnetlib.data.collective.harvest.provider.ItemUtility)
	 */
	@Override
	public void setItemParam(final ItemUtility itemUtility) {
		this.itemParam = itemUtility;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see eu.dnetlib.data.collective.harvest.provider.IClientProvider#isConnected()
	 */
	@Override
	public boolean isConnected() {
		return sftpChannel.isConnected();
	}
}

class UserSFTP implements UserInfo {

	String password;

	@Override
	public String getPassphrase() {
		return null;
	}

	public void setPassword(final String password) {
		this.password = password;
	}

	@Override
	public String getPassword() {
		// TODO Auto-generated method stub
		return password;
	}

	@Override
	public boolean promptPassphrase(final String arg0) {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean promptPassword(final String arg0) {
		password = "puppamelo";
		return true;
	}

	@Override
	public boolean promptYesNo(final String arg0) {
		// TODO Auto-generated method stub
		return true;
	}

	@Override
	public void showMessage(final String arg0) {
		// TODO Auto-generated method stub

	}

}
