package eu.dnetlib.data.collector.plugins.filesystem;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.util.concurrent.BlockingQueue;

import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.google.common.collect.Lists;

public class StringFileWalker extends FileWalker<String> {

	private static final Log log = LogFactory.getLog(StringFileWalker.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Override
	protected void doWalk() throws IOException {
		log.info("starting to iterate " + getType().toString() + " files under " + getSource().getAbsolutePath());

		walk(getSource(), getQueue());
		enqueue(getQueue(), FilesystemIterable.done);
	}

	@Override
	protected String readFile(final File file) throws IOException {

		FileInputStream fis = new FileInputStream(file);
		String fileContent = null;
		switch (getType()) {
		case TEXT:
			final StringWriter sw = new StringWriter();
			IOUtils.copy(fis, sw);
			sw.flush();
			fileContent = sw.toString();
			// remove BOM if present
			if (fileContent.startsWith("\uFEFF")) {
				fileContent = fileContent.substring(1);
			}
			break;

		default:
			throw new UnsupportedOperationException("FileType should be one of: " + Lists.newArrayList(FileType.values()));
		}
		fis.close();
		return fileContent;
	}

	public StringFileWalker(final BlockingQueue<String> queue, final FileType type, final String basePath) {
		super(queue, type, basePath);
	}

}
