package eu.dnetlib.data.collector.plugins.filesystem;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import eu.dnetlib.data.collector.plugins.filesystem.FileWalker.FileType;
import eu.dnetlib.data.collector.rmi.InterfaceDescriptor;

/**
 * 
 * @author andrea
 * 
 */
public class FilesystemIterable implements Iterable<String> {

	private static final Log log = LogFactory.getLog(FilesystemIterable.class);

	/** Queue sentinel **/
	public static final String done = "DONE";

	private final BlockingQueue<String> queue;

	private final String basePath;

	private ExecutorService producer;

	public FilesystemIterable(final InterfaceDescriptor descriptor) throws URISyntaxException {

		basePath = descriptor.getBaseUrl();
		this.producer = Executors.newSingleThreadExecutor();
		this.queue = new ArrayBlockingQueue<String>(20);
	}

	@Override
	public Iterator<String> iterator() {
		doReadFromFTP();
		return new FilesystemBlockingStream<String>(queue);
	}

	private void doReadFromFTP() {

		final FileWalker<String> walker = new StringFileWalker(queue, FileType.TEXT, basePath);
		producer.execute(new Runnable() {

			@Override
			public void run() {
				try {
					walker.doWalk();
				} catch (IOException e) {
					throw new IllegalStateException(e);
				}
				log.info("finished to iterate under " + basePath);
			}
		});
	}

}
