package eu.dnetlib.data.collector.plugins.filesystem;

import java.net.URISyntaxException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import eu.dnetlib.data.collector.plugin.CollectorPlugin;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import eu.dnetlib.data.collector.rmi.InterfaceDescriptor;

/**
 * 
 * @author andrea
 * 
 */
public class FilesystemCollectorPlugin implements CollectorPlugin {

	private static final Log log = LogFactory.getLog(FilesystemCollectorPlugin.class);

	@Override
	public Iterable<String> collect(final InterfaceDescriptor interfaceDescriptor) throws CollectorServiceException {

		final String baseUrl = interfaceDescriptor.getBaseUrl();

		if ((baseUrl == null) || baseUrl.isEmpty()) throw new CollectorServiceException("Param 'baseurl' is null or empty");

		try {
			return new FilesystemIterable(interfaceDescriptor);
		} catch (URISyntaxException e) {
			log.error("Filesystem collector failed! ", e);
			return null;
		}
	}

	@Override
	public String getProtocol() {
		return "filesystem";
	}
}
