package eu.dnetlib.data.collector.plugins;

import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

import au.com.bytecode.opencsv.CSVReader;
import eu.dnetlib.data.collector.plugin.CollectorPlugin;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import eu.dnetlib.data.collector.rmi.InterfaceDescriptor;

public class FileCSVCollectorPlugin implements CollectorPlugin {

	private static final Log log = LogFactory.getLog(FileCSVCollectorPlugin.class);

	class FileCSVIterator implements Iterator<String> {

		private String next = calculateNext();

		@Override
		public boolean hasNext() {
			return next != null;
		}

		@Override
		public String next() {
			try {
				return next;
			} finally {
				next = calculateNext();
			}
		}

		private String calculateNext() {
			try {
				Document document = DocumentHelper.createDocument();
				Element root = document.addElement("csvRecord");

				String[] currentRow = reader.readNext();

				if (currentRow != null) {

					for (int i = 0; i < currentRow.length; i++) {
						String hAttribute = headers == null ? "column" + i : headers[i];

						Element row = root.addElement("column");
						if (i == identifierNumber) {
							row.addAttribute("isID", "true");
						}
						row.addAttribute("name", hAttribute).addText(currentRow[i]);
					}
					return document.asXML();
				}
			} catch (IOException e) {
				log.error("Error calculating next csv element", e);
			}
			return null;
		}

		@Override
		public void remove() {

		}

	}

	private String[] headers = null;
	private CSVReader reader = null;
	private int identifierNumber;

	@Override
	public Iterable<String> collect(final InterfaceDescriptor interfaceDescriptor) throws CollectorServiceException {
		final String header = interfaceDescriptor.getParams().get("header");
		final String separator = StringEscapeUtils.unescapeJava(interfaceDescriptor.getParams().get("separator"));
		final String quote = interfaceDescriptor.getParams().get("quote");
		identifierNumber = Integer.parseInt(interfaceDescriptor.getParams().get("identifier"));
		URL u = null;
		try {
			u = new URL(interfaceDescriptor.getBaseUrl());
		} catch (MalformedURLException e1) {
			throw new CollectorServiceException(e1);
		}
		final String baseUrl = u.getPath();

		log.info("base URL = " + baseUrl);
		try {
			if (quote != null) {
				reader = new CSVReader(new FileReader(baseUrl), separator.charAt(0), quote.charAt(0));
			} else {
				reader = new CSVReader(new FileReader(baseUrl), separator.charAt(0));
			}
			if ((header != null) && ("true".equals(header.toLowerCase()))) {
				headers = reader.readNext();
			}

		} catch (Exception e) {
			throw new CollectorServiceException(e);
		}
		return new Iterable<String>() {

			@Override
			public Iterator<String> iterator() {
				return new FileCSVIterator();
			}
		};
	}

	@Override
	public String getProtocol() {

		return "fileCSV";
	}

}
