package eu.dnetlib.data.collector;

import java.util.List;

import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

import com.google.common.collect.Lists;

import eu.dnetlib.data.collector.plugin.CollectorPlugin;
import eu.dnetlib.data.collector.rmi.CollectorService;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import eu.dnetlib.data.collector.rmi.InterfaceDescriptor;
import eu.dnetlib.enabling.resultset.IterableResultSetFactory;
import eu.dnetlib.enabling.tools.AbstractBaseService;

public class CollectorServiceImpl extends AbstractBaseService implements CollectorService {

	@Resource
	private CollectorPluginEnumerator collectorPluginEnumerator;
	
	@Resource
	private IterableResultSetFactory iterableResultSetFactory;

	@Override
	public W3CEndpointReference collect(final InterfaceDescriptor ifDescriptor) throws CollectorServiceException {
		final CollectorPlugin plugin = collectorPluginEnumerator.get(ifDescriptor.getProtocol());
		final Iterable<String> iter = plugin.collect(ifDescriptor);
		return iterableResultSetFactory.createIterableResultSet(iter);
	}

	@Override
	public List<String> listProtocols() {
		return Lists.newArrayList(collectorPluginEnumerator.getByProtocols().keySet());
	}

}
