package eu.dnetlib.data.collector;

import java.util.Map;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ListableBeanFactory;

import com.google.common.collect.Maps;

import eu.dnetlib.data.collector.plugin.CollectorPlugin;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;

public class CollectorPluginEnumerator implements BeanFactoryAware {

	// private static final Log log = LogFactory.getLog(CollectorPluginEnumerator.class); // NOPMD by marko on 11/24/08 5:02 PM

	/**
	 * bean factory.
	 */
	private ListableBeanFactory beanFactory;

	/**
	 * Get all beans implementing the CollectorPlugin interface.
	 * 
	 * @return
	 */
	public Map<String, CollectorPlugin> getAll() {
		return beanFactory.getBeansOfType(CollectorPlugin.class);
	}

	/**
	 * Get all beans implementing the CollectorPlugin interface, hashed by protocol.
	 * 
	 * @return
	 */
	public Map<String, CollectorPlugin> getByProtocols() {
		final Map<String, CollectorPlugin> res = Maps.newHashMap();
		for (CollectorPlugin cp : getAll().values()) {
			res.put(cp.getProtocol().toLowerCase(), cp);
		}
		return res;
	}

	@Override
	public void setBeanFactory(final BeanFactory beanFactory) throws BeansException {
		this.beanFactory = (ListableBeanFactory) beanFactory;
	}

	public ListableBeanFactory getBeanFactory() {
		return beanFactory;
	}

	/**
	 * Get given CollectorPlugin or throws exception.
	 * 
	 * @param protocol
	 * @return
	 * @throws CollectorServiceException
	 */
	public CollectorPlugin get(final String protocol) throws CollectorServiceException {
		final CollectorPlugin plugin = getByProtocols().get(protocol.toLowerCase());
		if (plugin == null) throw new CollectorServiceException("plugin not found for protocol: " + protocol);
		return plugin;
	}
}
