package eu.dnetlib.data.mapreduce;

import java.io.IOException;

import javax.annotation.Resource;

import org.apache.hadoop.mapred.JobClient;

import eu.dnetlib.data.hadoop.config.ClusterName;
import eu.dnetlib.data.hadoop.config.ConfigurationEnumerator;

/**
 * Factory bean for jobClient instances
 * 
 * @author claudio
 * 
 */
public class JobClientFactory {

	@Resource
	private ConfigurationEnumerator configurationEnumerator;

	public JobClient newInstance(final String name) throws IOException {
		return new JobClient(configurationEnumerator.get(ClusterName.valueOf(name)));
	}

}
