/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.hadoop.oozie;

import eu.dnetlib.data.hadoop.action.JobCompletion;
import eu.dnetlib.data.hadoop.action.JobMonitor;
import eu.dnetlib.data.hadoop.rmi.HadoopServiceException;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.oozie.client.OozieClient;
import org.apache.oozie.client.OozieClientException;
import org.apache.oozie.client.WorkflowJob;

public class OozieJobMonitor
extends JobMonitor {
    private static final Log log = LogFactory.getLog(JobMonitor.class);
    private final int monitorSleepTimeSecs = 60;
    private final OozieClient oozieClient;
    private final String jobId;

    public OozieJobMonitor(OozieClient oozieClient, String jobId, JobCompletion callback) {
        super(callback);
        this.oozieClient = oozieClient;
        this.jobId = jobId;
    }

    @Override
    public void run() {
        try {
            log.info((Object)("waiting for oozie job completion: " + this.getHadoopId()));
            WorkflowJob.Status status = this.doGetStatus();
            while (status.equals((Object)WorkflowJob.Status.RUNNING)) {
                Thread.sleep(60000L);
                WorkflowJob.Status currentStatus = this.doGetStatus();
                if (status.equals((Object)currentStatus)) continue;
                status = currentStatus;
                this.lastActivity = new Date(System.currentTimeMillis());
            }
            log.debug((Object)("job " + this.jobId + " finihsed with status: " + status));
            if (status == WorkflowJob.Status.SUCCEEDED) {
                this.getCallback().done(new HashMap<String, String>());
                return;
            }
            String msg = "hadoop job: " + this.getHadoopId() + " failed with status: " + this.getStatus();
            this.getCallback().failed(msg, new HadoopServiceException(msg));
            return;
        }
        catch (Throwable e) {
            this.getCallback().failed(this.getHadoopId(), e);
            return;
        }
    }

    @Override
    public String getHadoopId() {
        return this.jobId;
    }

    public OozieClient getOozieClient() {
        return this.oozieClient;
    }

    @Override
    public String getStatus() {
        try {
            return this.doGetStatus().toString();
        }
        catch (OozieClientException e) {
            log.error((Object)"error accessing job status", (Throwable)e);
            return "UNKNOWN";
        }
    }

    private WorkflowJob.Status doGetStatus() throws OozieClientException {
        return this.getOozieClient().getJobInfo(this.getHadoopId()).getStatus();
    }

    @Override
    public Date getLastActivity() {
        return this.lastActivity;
    }

    @Override
    public Date getStartTime() throws HadoopServiceException {
        try {
            return this.getOozieClient().getJobInfo(this.getHadoopId()).getStartTime();
        }
        catch (OozieClientException e) {
            throw new HadoopServiceException("unable to read job start time", (Throwable)e);
        }
    }

    @Override
    public String getTrackerUrl() {
        return this.getOozieClient().getOozieUrl();
    }

    @Override
    public void kill() {
        try {
            this.getOozieClient().kill(this.getHadoopId());
        }
        catch (OozieClientException e) {
            log.error((Object)("unable to kill job: " + this.getHadoopId()), (Throwable)e);
        }
    }
}

