/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.hadoop.action;

import eu.dnetlib.data.hadoop.HadoopClientMap;
import eu.dnetlib.data.hadoop.HadoopJob;
import eu.dnetlib.data.hadoop.JobRegistry;
import eu.dnetlib.data.hadoop.action.AbstractSubmitAction;
import eu.dnetlib.data.hadoop.action.JobCompletion;
import eu.dnetlib.data.hadoop.config.ClusterName;
import eu.dnetlib.data.hadoop.oozie.OozieJobMonitor;
import eu.dnetlib.data.hadoop.rmi.HadoopServiceException;
import eu.dnetlib.data.hadoop.utils.JobProfile;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.client.OozieClient;
import org.springframework.beans.factory.annotation.Autowired;

public class SubmitOozieJobAction
extends AbstractSubmitAction {
    private static final Log log = LogFactory.getLog(SubmitOozieJobAction.class);
    @Autowired
    private HadoopClientMap clientMap;
    @Autowired
    private JobRegistry jobRegistry;

    @Override
    public void executeAsync(final BlackboardServerHandler handler, final BlackboardJob bbJob) {
        final String jobName = (String)bbJob.getParameters().get("job.name");
        ClusterName clusterName = ClusterName.valueOf((String)((String)bbJob.getParameters().get("cluster")));
        try {
            JobProfile jobProfile = this.loadISJobConfiguration(jobName, bbJob.getParameters());
            if (!bbJob.getParameters().keySet().containsAll(jobProfile.getRequiredParams())) {
                String msg = "required parameter is missing for job: " + jobName + ", required params: " + jobProfile.getRequiredParams();
                log.error((Object)msg);
                handler.failed(bbJob, (Throwable)new HadoopServiceException(msg));
                return;
            }
            Properties jobConf = this.prepareJob(this.getConf(clusterName), jobName, jobProfile, bbJob.getParameters());
            if (!this.clientMap.isOozieAvailable(clusterName)) {
                throw new HadoopServiceException("oozie not available for cluster: " + clusterName.toString());
            }
            OozieClient oozieClient = this.clientMap.getOozieClient(clusterName);
            final String internalId = oozieClient.run(jobConf);
            JobCompletion callback = new JobCompletion(){

                @Override
                public void done(Map<String, String> properties) {
                    bbJob.getParameters().putAll(properties);
                    log.info((Object)(String.valueOf(internalId) + " completed successfully"));
                    handler.done(bbJob);
                    SubmitOozieJobAction.this.decrementRunningJobs(jobName);
                }

                @Override
                public void failed(String msg, Throwable e) {
                    log.error((Object)msg);
                    handler.failed(bbJob, e);
                    SubmitOozieJobAction.this.decrementRunningJobs(jobName);
                }
            };
            String jobId = this.newJobId(clusterName, internalId);
            this.jobRegistry.registerJob(HadoopJob.newInstance(jobId, clusterName, jobProfile, new OozieJobMonitor(oozieClient, internalId, callback)));
            this.updateJobStatus(jobName);
            handler.ongoing(bbJob);
        }
        catch (Throwable e) {
            log.error((Object)("error executing hadoop job: " + jobName), e);
            handler.failed(bbJob, e);
        }
    }

    private Properties prepareJob(Configuration configuration, String jobName, JobProfile jobProfile, Map<String, String> parameters) throws IOException, HadoopServiceException {
        log.info((Object)("creating job: " + jobName));
        Properties p = new Properties();
        this.merge(p, jobProfile.getJobDefinition().entrySet());
        this.merge(p, parameters.entrySet());
        return p;
    }

    private void merge(Properties p, Iterable<Map.Entry<String, String>> entrySet) {
        for (Map.Entry<String, String> e : entrySet) {
            p.setProperty(e.getKey(), e.getValue());
        }
    }
}

