/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.hadoop.action;

import eu.dnetlib.data.hadoop.action.AbstractHadoopAction;
import eu.dnetlib.data.hadoop.config.ClusterName;
import eu.dnetlib.data.hadoop.config.ConfigurationEnumerator;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import java.io.IOException;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.springframework.beans.factory.annotation.Autowired;

public class DeleteHdfsPathAction
extends AbstractHadoopAction {
    private static final Log log = LogFactory.getLog(DeleteHdfsPathAction.class);
    @Autowired
    protected ConfigurationEnumerator configurationEnumerator;

    @Override
    protected void executeAsync(BlackboardServerHandler handler, BlackboardJob job) {
        try {
            ClusterName clusterName = ClusterName.valueOf((String)((String)job.getParameters().get("cluster")));
            log.info((Object)("delete request on cluster: " + clusterName.toString()));
            this.delete((String)job.getParameters().get("path"), this.configurationEnumerator.get(clusterName));
            handler.done(job);
        }
        catch (IOException e) {
            handler.failed(job, (Throwable)e);
        }
    }

    private void delete(String path, Configuration conf) throws IOException {
        Path absolutePath;
        FileSystem hdfs = FileSystem.get((Configuration)conf);
        if (hdfs.exists(absolutePath = new Path(URI.create(String.valueOf(conf.get("fs.defaultFS")) + path)))) {
            log.debug((Object)("delete path: " + absolutePath.toString()));
            hdfs.delete(absolutePath, true);
            log.info((Object)("deleted path: " + absolutePath.toString()));
        } else {
            log.warn((Object)("cannot delete unexisting path: " + absolutePath.toString()));
        }
    }
}

