/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.hadoop.action;

import com.google.common.collect.Iterables;
import eu.dnetlib.data.hadoop.action.AbstractHadoopAction;
import eu.dnetlib.data.hadoop.config.ClusterName;
import eu.dnetlib.data.hadoop.rmi.HadoopServiceException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryException;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.miscutils.functional.hash.Hashing;
import java.net.URI;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;

public abstract class AbstractSubmitAction
extends AbstractHadoopAction {
    private static final Log log = LogFactory.getLog(AbstractSubmitAction.class);
    @Resource(name="registryLocator")
    private ServiceLocator<ISRegistryService> registryLocator;

    protected void updateJobStatus(String jobName) throws HadoopServiceException {
        this.incrementCumulativeRun(jobName);
        this.incrementRunningJobs(jobName);
        this.updateDate(jobName);
    }

    protected void incrementRunningJobs(String jobName) {
        log.debug((Object)("increment #running jobs: " + jobName));
        this.updateCountElement(jobName, "RUNNING_INSTANCES", "+ 1");
    }

    protected void decrementRunningJobs(String jobName) {
        log.debug((Object)("decrement #running jobs: " + jobName));
        this.updateCountElement(jobName, "RUNNING_INSTANCES", "- 1");
    }

    protected void incrementCumulativeRun(String jobName) {
        log.debug((Object)("increment #cumulative runs for job: " + jobName));
        this.updateCountElement(jobName, "CUMULATIVE_RUN", "+ 1");
    }

    protected void updateDate(String jobName) {
        log.info((Object)("increment last submission date for job: " + jobName));
        String xquery = "for $x in collection('')/RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='HadoopJobConfigurationDSResourceType' and .//HADOOP_JOB/@name='" + jobName + "'] " + " return update value $x//LAST_SUBMISSION_DATE/@value with '" + DateUtils.now_ISO8601() + "' ";
        this.executeXUpdate(xquery);
    }

    private void updateCountElement(String jobName, String element, String delta) {
        String xquery = "let $x := //RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='HadoopJobConfigurationDSResourceType' and .//HADOOP_JOB/@name='" + jobName + "'], $tot := $x//STATUS/" + element + "/@value/number() " + delta + " return update replace $x//STATUS/" + element + " with <" + element + " value='{$tot}' />";
        this.executeXUpdate(xquery);
    }

    protected String newJobId(ClusterName clusterName, Object internalId) {
        return "job-" + Hashing.md5((String)(String.valueOf(clusterName.toString()) + internalId.toString()));
    }

    protected String getDefaultLibPath(String defaultFs) throws HadoopServiceException {
        try {
            String libPath = this.queryForServiceProperty("defaultLibPath");
            Path path = new Path(URI.create(String.valueOf(defaultFs) + libPath));
            return path.toString();
        }
        catch (ISLookUpException e) {
            throw new HadoopServiceException("unable to get default lib path", (Throwable)e);
        }
    }

    private String queryForServiceProperty(String key) throws ISLookUpException {
        return this.getServiceConfigValue("for $x in /RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='HadoopServiceResourceType'] return $x//SERVICE_PROPERTIES/PROPERTY[./@ key='" + key + "']/@value/string()");
    }

    private String getServiceConfigValue(String xquery) throws ISLookUpException {
        log.debug((Object)("quering for service property: " + xquery));
        List urls = ((ISLookUpService)this.getLookupLocator().getService()).quickSearchProfile(xquery);
        if (urls == null || urls.size() != 1) {
            throw new IllegalStateException("unable to find unique service property, xquery: " + xquery);
        }
        return (String)Iterables.getOnlyElement((Iterable)urls);
    }

    private boolean executeXUpdate(String xupdate) {
        try {
            log.debug((Object)("running xupdate: " + xupdate));
            return ((ISRegistryService)this.registryLocator.getService()).executeXUpdate(xupdate);
        }
        catch (ISRegistryException e) {
            log.error((Object)("unable to run xupdate: " + xupdate), (Throwable)e);
            return false;
        }
    }
}

