/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.hadoop.action;

import com.google.common.collect.Sets;
import eu.dnetlib.data.hadoop.config.ClusterName;
import eu.dnetlib.data.hadoop.config.ConfigurationEnumerator;
import eu.dnetlib.data.hadoop.rmi.HadoopBlackboardActions;
import eu.dnetlib.data.hadoop.rmi.HadoopServiceException;
import eu.dnetlib.data.hadoop.utils.JobProfile;
import eu.dnetlib.data.hadoop.utils.ScanFactory;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerAction;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractHadoopAction
implements BlackboardServerAction<HadoopBlackboardActions> {
    private static final Log log = LogFactory.getLog(AbstractHadoopAction.class);
    public static final Set<String> HDFS_SPECIAL_PROPERTIES = Sets.newHashSet((Object[])new String[]{"mapred.input.dir", "mapred.output.dir"});
    @Resource
    private ServiceLocator<ISLookUpService> lookupLocator;
    @Resource
    private ResultSetClientFactory resultSetClientFactory;
    @Autowired
    protected ConfigurationEnumerator configurationEnumerator;
    private final Executor executor = Executors.newCachedThreadPool();

    protected abstract void executeAsync(BlackboardServerHandler var1, BlackboardJob var2);

    public void execute(final BlackboardServerHandler handler, final BlackboardJob job) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                AbstractHadoopAction.this.executeAsync(handler, job);
            }
        });
    }

    protected JobProfile loadISJobConfiguration(String jobName, Map<String, String> bbParams) throws HadoopServiceException {
        log.info((Object)("reading job configuration profile: " + jobName));
        try {
            String profile = ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery("/RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'HadoopJobConfigurationDSResourceType' and .//HADOOP_JOB/@name='" + jobName + "']");
            return this.parseJobProfile(profile, bbParams);
        }
        catch (ISLookUpDocumentNotFoundException e) {
            throw new HadoopServiceException("cannot find job profile: " + jobName, (Throwable)e);
        }
        catch (ISLookUpException e) {
            throw new HadoopServiceException("unable to read job profile: " + jobName, (Throwable)e);
        }
    }

    private JobProfile parseJobProfile(String profile, Map<String, String> bbParams) throws HadoopServiceException {
        JobProfile jobProfile = new JobProfile();
        try {
            Node node;
            Document doc = new SAXReader().read((Reader)new StringReader(profile));
            log.debug((Object)"setting job description");
            jobProfile.setDescription(doc.valueOf("//DESCRIPTION"));
            log.debug((Object)"setting job name");
            jobProfile.setName(doc.valueOf("//HADOOP_JOB/@name"));
            log.debug((Object)"setting job static configuration");
            for (Object o : doc.selectNodes("//STATIC_CONFIGURATION/PROPERTY")) {
                node = (Node)o;
                jobProfile.getJobDefinition().put(node.valueOf("./@key"), node.valueOf("./@value"));
            }
            log.debug((Object)"setting job required parameters");
            for (Object o : doc.selectNodes("//JOB_INTERFACE/PARAM[./@required = 'true']")) {
                node = (Node)o;
                jobProfile.getRequiredParams().add(node.valueOf("./@name"));
            }
            if (doc.selectSingleNode("//SCAN") != null) {
                jobProfile.setScanProperties(ScanFactory.parseScanProperties(doc, bbParams));
            }
        }
        catch (DocumentException e) {
            throw new HadoopServiceException("cannot parse job profile");
        }
        if (jobProfile.isEmpty()) {
            throw new HadoopServiceException("job configuration is empty");
        }
        return jobProfile;
    }

    protected Configuration getConf(ClusterName clusterName) {
        return this.configurationEnumerator.get(clusterName);
    }

    protected ServiceLocator<ISLookUpService> getLookupLocator() {
        return this.lookupLocator;
    }

    protected boolean checkHdfsProperty(Map.Entry<String, String> e) {
        return HDFS_SPECIAL_PROPERTIES.contains(e.getKey()) && !e.getValue().isEmpty() && !e.getValue().startsWith("hdfs://");
    }
}

