/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.hadoop;

import com.google.common.collect.Lists;
import eu.dnetlib.data.hadoop.HadoopServiceCore;
import eu.dnetlib.data.hadoop.JobRegistry;
import eu.dnetlib.data.hadoop.config.ClusterName;
import eu.dnetlib.data.hadoop.rmi.HadoopJobDescriptor;
import eu.dnetlib.data.hadoop.rmi.HadoopService;
import eu.dnetlib.data.hadoop.rmi.HadoopServiceException;
import eu.dnetlib.enabling.tools.AbstractBaseService;
import eu.dnetlib.enabling.tools.blackboard.NotificationHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class HadoopServiceImpl
extends AbstractBaseService
implements HadoopService {
    private NotificationHandler notificationHandler;
    @Autowired
    private HadoopServiceCore hadoopServiceCore;
    @Autowired
    private JobRegistry jobRegistry;

    public List<String> listAvailableJobs() throws HadoopServiceException {
        ArrayList res = Lists.newArrayList();
        return res;
    }

    public List<HadoopJobDescriptor> listJobs(String clusterName) throws HadoopServiceException {
        return this.jobRegistry.listJobs(ClusterName.valueOf((String)clusterName));
    }

    public boolean killJob(String jobId) throws HadoopServiceException {
        this.jobRegistry.unregisterJob(jobId);
        return true;
    }

    public void notify(String subscriptionId, String topic, String isId, String message) {
        this.getNotificationHandler().notified(subscriptionId, topic, isId, message);
    }

    public List<String> listHbaseTables(String clusterName) throws HadoopServiceException {
        try {
            return this.hadoopServiceCore.listTables(ClusterName.valueOf((String)clusterName));
        }
        catch (IOException e) {
            throw new HadoopServiceException((Throwable)e);
        }
    }

    public boolean ensureHbaseTable(String clusterName, String tableName, Set<String> columns) throws HadoopServiceException {
        try {
            this.hadoopServiceCore.ensureTable(ClusterName.valueOf((String)clusterName), tableName, columns);
            return true;
        }
        catch (IOException e) {
            throw new HadoopServiceException((Throwable)e);
        }
    }

    public boolean createHbaseTable(String clusterName, String tableName, Set<String> columns) throws HadoopServiceException {
        try {
            this.hadoopServiceCore.createTable(ClusterName.valueOf((String)clusterName), tableName, columns);
            return true;
        }
        catch (IOException e) {
            throw new HadoopServiceException((Throwable)e);
        }
    }

    public boolean truncateHbaseTable(String clusterName, String tableName) throws HadoopServiceException {
        try {
            this.hadoopServiceCore.truncateTable(ClusterName.valueOf((String)clusterName), tableName);
        }
        catch (IOException e) {
            throw new HadoopServiceException((Throwable)e);
        }
        return true;
    }

    public NotificationHandler getNotificationHandler() {
        return this.notificationHandler;
    }

    @Required
    public void setNotificationHandler(NotificationHandler notificationHandler) {
        this.notificationHandler = notificationHandler;
    }
}

