/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.hadoop;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import eu.dnetlib.data.hadoop.HadoopClients;
import eu.dnetlib.data.hadoop.config.ClusterName;
import eu.dnetlib.data.hadoop.hbase.HBaseAdminFactory;
import eu.dnetlib.data.hadoop.oozie.OozieClientFactory;
import eu.dnetlib.data.hadoop.rmi.HadoopServiceException;
import eu.dnetlib.data.mapreduce.JobClientFactory;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.mapred.JobClient;
import org.apache.oozie.client.OozieClient;
import org.springframework.beans.factory.annotation.Autowired;

public class HadoopClientMap {
    private static final Log log = LogFactory.getLog(HadoopClientMap.class);
    @Autowired
    private JobClientFactory jobClientFactory;
    @Autowired
    private OozieClientFactory oozieClientFactory;
    @Autowired
    private HBaseAdminFactory hbaseAdminFactory;
    private List<String> enabledClusters = Lists.newArrayList();
    private final Map<ClusterName, HadoopClients> clients = Maps.newHashMap();

    public void init() throws HadoopServiceException {
        for (String name : this.getEnabledClusters()) {
            log.info((Object)("initializing clients for hadoop cluster: " + name));
            ClusterName clusterName = ClusterName.valueOf((String)name);
            try {
                this.clients.put(clusterName, new HadoopClients(this.jobClientFactory.newInstance(name), this.oozieClientFactory.newInstance(clusterName), this.hbaseAdminFactory.newInstance(clusterName)));
            }
            catch (IOException e) {
                throw new HadoopServiceException((Throwable)e);
            }
        }
    }

    public JobClient getJtClient(ClusterName name) {
        return this.getClients(name).getJtClient();
    }

    public OozieClient getOozieClient(ClusterName name) {
        return this.getClients(name).getOozieClient();
    }

    public boolean isOozieAvailable(ClusterName name) {
        return this.getClients(name).isOozieAvailable();
    }

    public HBaseAdmin getHbaseAdmin(ClusterName name) {
        return this.getClients(name).getHbaseAdmin();
    }

    public HadoopClients getClients(ClusterName name) {
        HadoopClients hadoopClients = this.clients.get(name);
        if (hadoopClients == null) {
            throw new IllegalArgumentException("cluster " + name.toString() + " is currently disabled");
        }
        return hadoopClients;
    }

    public List<String> getEnabledClusters() {
        return this.enabledClusters;
    }

    public void setEnabledClusters(List<String> enabledClusters) {
        this.enabledClusters = enabledClusters;
    }
}

