package eu.dnetlib.data.hadoop.config;

import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

import com.google.common.base.Function;
import com.google.common.collect.Maps;

public class ConfigurationEnumerator implements BeanFactoryAware {

	private static final Log log = LogFactory.getLog(ConfigurationEnumerator.class); // NOPMD by marko on 11/24/08 5:02 PM

	/**
	 * bean factory.
	 */
	private ListableBeanFactory beanFactory;

	private final Function<ConfigurationFactory, Configuration> asConfiguration = new Function<ConfigurationFactory, Configuration>() {
		@Override
		public Configuration apply(ConfigurationFactory factory) {
			return factory.getConfiguration();
		}
	};

	/**
	 * Get all beans implementing the ConfiguredJob interface.
	 * 
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public Map<String, Configuration> getAll() {
		return Maps.transformValues(beanFactory.getBeansOfType(ConfigurationFactory.class), asConfiguration);
	}

	@Override
	public void setBeanFactory(final BeanFactory beanFactory) throws BeansException {
		this.beanFactory = (ListableBeanFactory) beanFactory;
	}

	public ListableBeanFactory getBeanFactory() {
		return beanFactory;
	}

	/**
	 * Get given Configuration or null.
	 * 
	 * @param name
	 * @return
	 */
	public Configuration get(final ClusterName name) {
		try {
			return ((Configuration) beanFactory.getBean(name.toString(), Configuration.class));
		} catch (final NoSuchBeanDefinitionException e) {
			log.error("undefined bean: " + name, e);
			return null;
		}
	}
}
