package eu.dnetlib.msro.eagle.ui;

import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;

import eu.dnetlib.data.download.rmi.DownloadPluginEnumerator;
import eu.dnetlib.msro.workflows.util.ValidNodeValuesFetcher;

public class DownloadPluginValues extends ValidNodeValuesFetcher {

	/** The download plugin enumerator. */
	@Resource
	private DownloadPluginEnumerator downloadPluginEnumerator;

	@Override
	protected List<DnetParamValue> obtainValues(final Map<String, String> params) throws Exception {

		return Lists.newArrayList(Iterables.transform(downloadPluginEnumerator.getAll().keySet(), new Function<String, DnetParamValue>() {

			@Override
			public DnetParamValue apply(final String input) {
				return new DnetParamValue(input, input);
			}
		}));
	}

	/**
	 * @return the downloadPluginEnumerator
	 */
	public DownloadPluginEnumerator getDownloadPluginEnumerator() {
		return downloadPluginEnumerator;
	}

	/**
	 * @param downloadPluginEnumerator
	 *            the downloadPluginEnumerator to set
	 */
	public void setDownloadPluginEnumerator(final DownloadPluginEnumerator downloadPluginEnumerator) {
		this.downloadPluginEnumerator = downloadPluginEnumerator;
	}
}
