/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.springutils.template;

import eu.dnetlib.springutils.template.TestBean;
import javax.annotation.Resource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration
public class TemplateTest {
    @Resource(name="test")
    private transient TestBean testBean;
    @Resource(name="testDefault1")
    private transient TestBean testDefault1;
    @Resource(name="testDefault2")
    private transient TestBean testDefault2;
    @Resource(name="testDefault3")
    private transient TestBean testDefault3;

    @Before
    public void setUp() throws Exception {
    }

    @Test
    public void testTemplate() {
        Assert.assertEquals((String)"check property value expansion", (Object)"expandedValue", (Object)this.testBean.getAddress());
        Assert.assertEquals((String)"check bean reference", (Object)"tail-expandedValue", (Object)this.testBean.getNext().getAddress());
    }

    @Test
    public void testMultipleInstances() {
        Assert.assertEquals((String)"check expanded value", (Object)"expandedValue", (Object)this.testDefault1.getAddress());
        Assert.assertEquals((String)"check other value", (Object)"otherValue", (Object)this.testDefault2.getAddress());
    }

    @Test
    public void testDefault() {
        Assert.assertEquals((String)"check expanded value", (Object)"expandedValue", (Object)this.testDefault1.getAddress());
        Assert.assertEquals((String)"check default value", (Object)"defaultValue", (Object)this.testDefault3.getAddress());
    }

    @Test
    public void testProp() {
        Assert.assertEquals((String)"check property", (Object)"test", (Object)this.testBean.getProp());
    }
}

