/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.springutils.template;

import eu.dnetlib.springutils.template.BeanTemplate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.BeanDefinitionParserDelegate;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class TemplateInstance {
    private static final Log log = LogFactory.getLog(TemplateInstance.class);
    private static final String NAMESPACE_P = "http://www.springframework.org/schema/p";
    static final String NAMESPACE_T = "http://dnetlib.eu/springbeans/t";
    private Element element;
    private ParserContext parserContext;

    public TemplateInstance(Element element, ParserContext parserContext) {
        this.element = element;
        this.parserContext = parserContext;
    }

    public String getTemplateName() {
        return this.element.getAttribute("name");
    }

    public void instantiate(BeanTemplate template) {
        log.debug((Object)("instantiating template " + template.getName()));
        BeanDefinitionParserDelegate delegate = this.parserContext.getDelegate();
        List beans = DomUtils.getChildElementsByTagName((Element)template.getRoot(), (String)"bean");
        log.debug((Object)("found child elements beans: " + beans));
        for (Element el : beans) {
            Element cel = (Element)el.cloneNode(true);
            this.expandTemplateParameters(cel, this.element, template);
            BeanDefinitionHolder holder = delegate.parseBeanDefinitionElement(cel);
            BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)this.parserContext.getRegistry());
            delegate.decorateBeanDefinitionIfRequired(cel, holder);
        }
    }

    private void expandTemplateParameters(Element el, Element instance, BeanTemplate template) {
        NamedNodeMap attrs = el.getAttributes();
        Map<String, String> templateParameters = this.getTemplateParameters(instance, template);
        int i = 0;
        while (i < attrs.getLength()) {
            StringTemplate stp;
            Node node = attrs.item(i);
            Attr attr = (Attr)node;
            if (NAMESPACE_T.equals(attr.getNamespaceURI())) {
                log.debug((Object)("found template attribute: " + attr.getLocalName()));
                stp = new StringTemplate(attr.getValue());
                stp.setArgumentContext(templateParameters);
                el.setAttribute(attr.getLocalName(), stp.toString());
            } else if (NAMESPACE_P.equals(attr.getNamespaceURI())) {
                log.debug((Object)("found potential template property: " + attr.getLocalName()));
                if (attr.getValue().contains("$")) {
                    stp = new StringTemplate(attr.getValue());
                    stp.setArgumentContext(templateParameters);
                    el.setAttributeNS(NAMESPACE_P, attr.getLocalName(), stp.toString());
                }
            }
            ++i;
        }
    }

    private Map<String, String> getTemplateParameters(Element instance, BeanTemplate template) {
        HashMap<String, String> map = new HashMap<String, String>();
        this.fillParameterMap(map, template.getRoot());
        this.fillParameterMap(map, instance);
        List params = DomUtils.getChildElementsByTagName((Element)instance, (String)"parameter");
        for (Element param : params) {
            map.put(param.getAttribute("name"), param.getAttribute("value"));
        }
        return map;
    }

    private void fillParameterMap(Map<String, String> map, Element element) {
        NamedNodeMap attrs = element.getAttributes();
        int i = 0;
        while (i < attrs.getLength()) {
            Node node = attrs.item(i);
            Attr attr = (Attr)node;
            if (NAMESPACE_T.equals(attr.getNamespaceURI())) {
                map.put(attr.getLocalName(), attr.getValue());
            }
            ++i;
        }
    }

    public Element getElement() {
        return this.element;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    public ParserContext getParserContext() {
        return this.parserContext;
    }

    public void setParserContext(ParserContext parserContext) {
        this.parserContext = parserContext;
    }
}

