/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.springutils.template;

import eu.dnetlib.springutils.template.BeanTemplate;
import eu.dnetlib.springutils.template.BeanTemplateDao;
import eu.dnetlib.springutils.template.TemplateInstance;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BeanTemplateDaoImpl
implements BeanTemplateDao {
    Map<String, BeanTemplate> byName = new HashMap<String, BeanTemplate>();
    Map<String, List<TemplateInstance>> instances = new HashMap<String, List<TemplateInstance>>();

    @Override
    public BeanTemplate getTemplate(String name) {
        return this.byName.get(name);
    }

    @Override
    public void registerTemplate(BeanTemplate template) {
        this.byName.put(template.getName(), template);
        for (TemplateInstance instance : this.getInstancesForTemplate(template)) {
            instance.instantiate(template);
        }
    }

    @Override
    public List<TemplateInstance> getInstancesForTemplate(BeanTemplate template) {
        return this.getInstancesForTemplate(template.getName());
    }

    public List<TemplateInstance> getInstancesForTemplate(String templateName) {
        List<TemplateInstance> list = this.instances.get(templateName);
        if (list == null) {
            list = new ArrayList<TemplateInstance>();
        }
        return list;
    }

    @Override
    public void registerTemplateInstance(TemplateInstance instance) {
        List<TemplateInstance> list = this.getInstancesForTemplate(instance.getTemplateName());
        list.add(instance);
        this.instances.put(instance.getTemplateName(), list);
    }
}

