/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.springutils.stringtemplate;

import eu.dnetlib.springutils.stringtemplate.StringTemplateView;
import java.util.Locale;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContextException;
import org.springframework.web.servlet.view.AbstractUrlBasedView;
import org.springframework.web.servlet.view.UrlBasedViewResolver;

public class StringTemplateViewResolver
extends UrlBasedViewResolver {
    private StringTemplateGroup templateGroup;

    public void setTemplateGroup(StringTemplateGroup value) {
        this.templateGroup = value;
    }

    public StringTemplateGroup getTemplateGroup() {
        return this.templateGroup;
    }

    public StringTemplateViewResolver() {
        this.setViewClass(this.requiredViewClass());
        this.setRequestContextAttribute("rc");
    }

    protected Class requiredViewClass() {
        return StringTemplateView.class;
    }

    protected void initApplicationContext() {
        super.initApplicationContext();
        if (this.getTemplateGroup() == null) {
            this.setTemplateGroup(this.autodetectMyStringTemplateGroup());
        }
    }

    protected StringTemplateGroup autodetectMyStringTemplateGroup() {
        try {
            StringTemplateGroup group = (StringTemplateGroup)BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)this.getApplicationContext(), StringTemplateGroup.class, (boolean)true, (boolean)false);
            return group;
        }
        catch (NoSuchBeanDefinitionException ex) {
            throw new ApplicationContextException("Must define a single StringTemplateGroup bean in this web application context (may be inherited). StringTemplateGroup is the usual implementation. This bean may be given any name.", (Throwable)ex);
        }
    }

    protected AbstractUrlBasedView buildView(String viewName) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("looking up by view name: '" + viewName + "' based in '" + this.getPrefix() + "'"));
        }
        StringTemplateView view = (StringTemplateView)super.buildView(String.valueOf(this.getPrefix()) + viewName);
        view.setStringTemplate(this.templateGroup.getInstanceOf(String.valueOf(this.getPrefix()) + viewName));
        return view;
    }

    protected boolean canHandle(String viewName, Locale locale) {
        if (viewName.startsWith("redirect:")) {
            return true;
        }
        try {
            this.templateGroup.getInstanceOf(String.valueOf(this.getPrefix()) + viewName);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        if (super.canHandle(viewName, locale)) {
            return true;
        }
        return true;
    }
}

