/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.springutils.stringtemplate;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateErrorListener;
import org.antlr.stringtemplate.StringTemplateGroup;

public class ClassPathStringTemplateGroup
extends StringTemplateGroup {
    private String prefix = "";

    public ClassPathStringTemplateGroup(String arg0) {
        super(arg0);
    }

    public ClassPathStringTemplateGroup(Reader arg0) {
        super(arg0);
    }

    public ClassPathStringTemplateGroup(String arg0, String arg1) {
        super(arg0, arg1);
    }

    public ClassPathStringTemplateGroup(String arg0, Class arg1) {
        super(arg0, arg1);
    }

    public ClassPathStringTemplateGroup(Reader arg0, StringTemplateErrorListener arg1) {
        super(arg0, arg1);
    }

    public ClassPathStringTemplateGroup(Reader arg0, Class arg1) {
        super(arg0, arg1);
    }

    public ClassPathStringTemplateGroup(String arg0, String arg1, Class arg2) {
        super(arg0, arg1, arg2);
    }

    public ClassPathStringTemplateGroup(Reader arg0, Class arg1, StringTemplateErrorListener arg2) {
        super(arg0, arg1, arg2);
    }

    public ClassPathStringTemplateGroup(Reader arg0, Class arg1, StringTemplateErrorListener arg2, StringTemplateGroup arg3) {
        super(arg0, arg1, arg2, arg3);
    }

    public String getFileNameFromTemplateName(String fileName) {
        return String.valueOf(this.getPrefix()) + super.getFileNameFromTemplateName(fileName);
    }

    public String getTemplateNameFromFileName(String fileName) {
        if (fileName.startsWith(this.getPrefix())) {
            return super.getTemplateNameFromFileName(fileName.substring(this.getPrefix().length()));
        }
        return super.getTemplateNameFromFileName(fileName);
    }

    public void setPackage(String packageName) {
        this.setPrefix("/" + packageName.replace('.', '/') + "/");
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    protected StringTemplate loadTemplateFromBeneathRootDirOrCLASSPATH(String fileName) {
        String name = this.getTemplateNameFromFileName(fileName);
        InputStream input = ((Object)((Object)this)).getClass().getResourceAsStream(fileName);
        if (input == null) {
            throw new IllegalArgumentException("resource " + fileName + " doesn't exist");
        }
        BufferedReader breader = null;
        try {
            breader = new BufferedReader(this.getInputStreamReader(input));
            StringTemplate stringTemplate = this.loadTemplate(name, breader);
            return stringTemplate;
        }
        catch (IOException ioe) {
            this.error("Problem reading template file: " + fileName, ioe);
        }
        finally {
            if (breader != null) {
                try {
                    breader.close();
                }
                catch (IOException ioe2) {
                    this.error("Cannot close template file: " + fileName, ioe2);
                }
            }
        }
        return null;
    }
}

