/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.springutils.condbean.parser.ast;

import eu.dnetlib.springutils.condbean.parser.ast.AbstractExpression;
import eu.dnetlib.springutils.condbean.parser.ast.OrExpression;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class OrExpressionTest {
    private static final String CHECK_EXPRESSION = "check expression";
    private OrExpression expr;
    private AbstractExpression left;
    private AbstractExpression right;

    @Before
    public void setUp() throws Exception {
        this.left = (AbstractExpression)Mockito.mock(AbstractExpression.class);
        this.right = (AbstractExpression)Mockito.mock(AbstractExpression.class);
        this.expr = new OrExpression(this.left, this.right);
    }

    @Test
    public void testTrue() {
        Mockito.when((Object)this.left.evaluate()).thenReturn((Object)true);
        Mockito.when((Object)this.right.evaluate()).thenReturn((Object)true);
        Assert.assertTrue((String)CHECK_EXPRESSION, (boolean)((Boolean)this.expr.evaluate()));
    }

    @Test
    public void testFalse() {
        Mockito.when((Object)this.left.evaluate()).thenReturn((Object)true);
        Mockito.when((Object)this.right.evaluate()).thenReturn((Object)false);
        Assert.assertTrue((String)CHECK_EXPRESSION, (boolean)((Boolean)this.expr.evaluate()));
    }

    @Test
    public void testOneNull() {
        Mockito.when((Object)this.left.evaluate()).thenReturn(null);
        Mockito.when((Object)this.right.evaluate()).thenReturn((Object)1);
        Assert.assertTrue((String)CHECK_EXPRESSION, (boolean)((Boolean)this.expr.evaluate()));
    }

    @Test
    public void testBothNull() {
        Mockito.when((Object)this.left.evaluate()).thenReturn(null);
        Mockito.when((Object)this.right.evaluate()).thenReturn(null);
        Assert.assertFalse((String)CHECK_EXPRESSION, (boolean)((Boolean)this.expr.evaluate()));
    }

    public OrExpression getExpr() {
        return this.expr;
    }

    public void setExpr(OrExpression expr) {
        this.expr = expr;
    }

    public AbstractExpression getLeft() {
        return this.left;
    }

    public void setLeft(AbstractExpression left) {
        this.left = left;
    }

    public AbstractExpression getRight() {
        return this.right;
    }

    public void setRight(AbstractExpression right) {
        this.right = right;
    }
}

