/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.springutils.condbean.parser.ast;

import eu.dnetlib.springutils.condbean.parser.ast.AbstractExpression;
import eu.dnetlib.springutils.condbean.parser.ast.EqualityExpression;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class EqualityExpressionTest {
    private static final String CHECK_EXPRESSION = "check expression";
    private EqualityExpression expr;
    private AbstractExpression left;
    private AbstractExpression right;

    @Before
    public void setUp() throws Exception {
        this.left = (AbstractExpression)Mockito.mock(AbstractExpression.class);
        this.right = (AbstractExpression)Mockito.mock(AbstractExpression.class);
        this.expr = new EqualityExpression(this.left, this.right, "==");
    }

    @Test
    public void testEquals() {
        Mockito.when((Object)this.left.evaluate()).thenReturn((Object)"pippo");
        Mockito.when((Object)this.right.evaluate()).thenReturn((Object)"pippo");
        Assert.assertTrue((String)CHECK_EXPRESSION, (boolean)((Boolean)this.expr.evaluate()));
    }

    @Test
    public void testNotEquals() {
        Mockito.when((Object)this.left.evaluate()).thenReturn((Object)"pippo1");
        Mockito.when((Object)this.right.evaluate()).thenReturn((Object)"puppo");
        Assert.assertFalse((String)CHECK_EXPRESSION, (boolean)((Boolean)this.expr.evaluate()));
    }

    @Test
    public void testInteger() {
        Mockito.when((Object)this.left.evaluate()).thenReturn((Object)"pippo1");
        Mockito.when((Object)this.right.evaluate()).thenReturn((Object)1);
        Assert.assertFalse((String)CHECK_EXPRESSION, (boolean)((Boolean)this.expr.evaluate()));
    }

    @Test
    public void testOneNull() {
        Mockito.when((Object)this.left.evaluate()).thenReturn(null);
        Mockito.when((Object)this.right.evaluate()).thenReturn((Object)1);
        Assert.assertFalse((String)CHECK_EXPRESSION, (boolean)((Boolean)this.expr.evaluate()));
    }

    @Test
    public void testBothNull() {
        Mockito.when((Object)this.left.evaluate()).thenReturn(null);
        Mockito.when((Object)this.right.evaluate()).thenReturn(null);
        Assert.assertTrue((String)CHECK_EXPRESSION, (boolean)((Boolean)this.expr.evaluate()));
    }

    @Test
    public void testIntString() {
        Mockito.when((Object)this.left.evaluate()).thenReturn((Object)1);
        Mockito.when((Object)this.right.evaluate()).thenReturn((Object)"1");
        Assert.assertFalse((String)CHECK_EXPRESSION, (boolean)((Boolean)this.expr.evaluate()));
    }

    @Test
    public void testIntChar() {
        Mockito.when((Object)this.left.evaluate()).thenReturn((Object)1);
        Mockito.when((Object)this.right.evaluate()).thenReturn((Object)Character.valueOf('1'));
        Assert.assertFalse((String)CHECK_EXPRESSION, (boolean)((Boolean)this.expr.evaluate()));
    }

    @Test
    public void testString() {
        Mockito.when((Object)this.left.evaluate()).thenReturn((Object)"2");
        Mockito.when((Object)this.right.evaluate()).thenReturn((Object)"3");
        Assert.assertFalse((String)CHECK_EXPRESSION, (boolean)((Boolean)this.expr.evaluate()));
    }

    public EqualityExpression getExpr() {
        return this.expr;
    }

    public void setExpr(EqualityExpression expr) {
        this.expr = expr;
    }

    public AbstractExpression getLeft() {
        return this.left;
    }

    public void setLeft(AbstractExpression left) {
        this.left = left;
    }

    public AbstractExpression getRight() {
        return this.right;
    }

    public void setRight(AbstractExpression right) {
        this.right = right;
    }
}

