/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.springutils.condbean.parser;

import eu.dnetlib.springutils.condbean.parser.CondBeanParser;
import eu.dnetlib.springutils.condbean.parser.RunccExpressionParser;
import eu.dnetlib.springutils.condbean.parser.ast.AndExpression;
import eu.dnetlib.springutils.condbean.parser.ast.EqualityExpression;
import eu.dnetlib.springutils.condbean.parser.ast.OrExpression;
import eu.dnetlib.springutils.condbean.parser.ast.RelationalExpression;
import eu.dnetlib.springutils.condbean.parser.ast.SysProperty;
import java.io.IOException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RunccExpressionParserTest {
    private static final String CHECK_EXPRESSION = "check expression value";
    private static final String EXPRESSION_TYPE = "check expression type";
    private String parseInput;
    private RunccExpressionParser parser;

    @Before
    public void setProperties() {
        System.setProperty("some.existing.property", "pippo");
        this.parser = new RunccExpressionParser();
        this.parser.setCondBeanParser(new CondBeanParser());
    }

    @After
    public void cleanupProperties() {
        System.clearProperty("some.existing.property");
    }

    @Test
    public void test0() throws IOException {
        this.parseInput = "${some.existing.property}";
        Assert.assertTrue((String)CHECK_EXPRESSION, (boolean)this.parser.expressionValue(this.parseInput));
        Assert.assertTrue((String)EXPRESSION_TYPE, (boolean)(this.parser.getTopRule(this.parseInput) instanceof SysProperty));
    }

    @Test
    public void test1() throws IOException {
        this.parseInput = "false && false";
        Assert.assertFalse((String)CHECK_EXPRESSION, (boolean)this.parser.expressionValue(this.parseInput));
        Assert.assertTrue((String)EXPRESSION_TYPE, (boolean)(this.parser.getTopRule(this.parseInput) instanceof AndExpression));
    }

    @Test
    public void test2() throws IOException {
        this.parseInput = "1<2";
        Assert.assertTrue((String)CHECK_EXPRESSION, (boolean)this.parser.expressionValue(this.parseInput));
        Assert.assertTrue((String)EXPRESSION_TYPE, (boolean)(this.parser.getTopRule(this.parseInput) instanceof RelationalExpression));
    }

    @Test
    public void test3() throws IOException {
        this.parseInput = "!${some.existing.property} && ${some.value} == 3 || isdef(someBean) || 11";
        Assert.assertTrue((String)CHECK_EXPRESSION, (boolean)this.parser.expressionValue(this.parseInput));
        Assert.assertTrue((String)EXPRESSION_TYPE, (boolean)(this.parser.getTopRule(this.parseInput) instanceof OrExpression));
    }

    @Test
    public void test4() throws IOException {
        this.parseInput = "2 == 3";
        Assert.assertFalse((String)CHECK_EXPRESSION, (boolean)this.parser.expressionValue(this.parseInput));
        Assert.assertTrue((String)EXPRESSION_TYPE, (boolean)(this.parser.getTopRule(this.parseInput) instanceof EqualityExpression));
    }

    @Test
    public void test5() throws IOException {
        this.parseInput = "\"3\"==3";
        Assert.assertFalse((String)CHECK_EXPRESSION, (boolean)this.parser.expressionValue(this.parseInput));
        Assert.assertTrue((String)EXPRESSION_TYPE, (boolean)(this.parser.getTopRule(this.parseInput) instanceof EqualityExpression));
    }

    @Test
    public void test6() throws IOException {
        this.parseInput = "${some.value} == 3";
        Assert.assertFalse((String)CHECK_EXPRESSION, (boolean)this.parser.expressionValue(this.parseInput));
        Assert.assertTrue((String)EXPRESSION_TYPE, (boolean)(this.parser.getTopRule(this.parseInput) instanceof EqualityExpression));
    }

    @Test
    public void test7() throws IOException {
        this.parseInput = "!${some.existing.property} && ${some.value} == 3";
        Assert.assertFalse((String)CHECK_EXPRESSION, (boolean)this.parser.expressionValue(this.parseInput));
        Assert.assertTrue((String)EXPRESSION_TYPE, (boolean)(this.parser.getTopRule(this.parseInput) instanceof AndExpression));
    }

    @Test
    public void test8() throws IOException {
        this.parseInput = "${some.value} == 3 && !${some.existing.property}";
        Assert.assertFalse((String)CHECK_EXPRESSION, (boolean)this.parser.expressionValue(this.parseInput));
        Assert.assertTrue((String)EXPRESSION_TYPE, (boolean)(this.parser.getTopRule(this.parseInput) instanceof AndExpression));
    }

    @Test
    public void test9() throws IOException {
        this.parseInput = "3 < 2 && 2<4";
        Assert.assertFalse((String)CHECK_EXPRESSION, (boolean)this.parser.expressionValue(this.parseInput));
        Assert.assertTrue((String)EXPRESSION_TYPE, (boolean)(this.parser.getTopRule(this.parseInput) instanceof AndExpression));
    }

    @Test
    public void test10() throws IOException {
        this.parseInput = "3 < 2 || 2<4";
        Assert.assertTrue((String)CHECK_EXPRESSION, (boolean)this.parser.expressionValue(this.parseInput));
        Assert.assertTrue((String)EXPRESSION_TYPE, (boolean)(this.parser.getTopRule(this.parseInput) instanceof OrExpression));
    }

    @Test
    public void test11() throws IOException {
        this.parseInput = "3==3";
        Assert.assertTrue((String)CHECK_EXPRESSION, (boolean)this.parser.expressionValue(this.parseInput));
        Assert.assertTrue((String)EXPRESSION_TYPE, (boolean)(this.parser.getTopRule(this.parseInput) instanceof EqualityExpression));
    }

    public String getParseInput() {
        return this.parseInput;
    }

    public void setParseInput(String parseInput) {
        this.parseInput = parseInput;
    }

    public RunccExpressionParser getParser() {
        return this.parser;
    }

    public void setParser(RunccExpressionParser parser) {
        this.parser = parser;
    }
}

