/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.springutils.condbean.parser;

import eu.dnetlib.springutils.condbean.parser.CondBeanParser;
import eu.dnetlib.springutils.condbean.parser.ast.AbstractExpression;
import fri.patterns.interpreter.parsergenerator.Lexer;
import fri.patterns.interpreter.parsergenerator.Parser;
import fri.patterns.interpreter.parsergenerator.ParserTables;
import fri.patterns.interpreter.parsergenerator.Semantic;
import fri.patterns.interpreter.parsergenerator.lexer.LexerBuilder;
import fri.patterns.interpreter.parsergenerator.lexer.LexerException;
import fri.patterns.interpreter.parsergenerator.parsertables.LALRParserTables;
import fri.patterns.interpreter.parsergenerator.syntax.SyntaxException;
import fri.patterns.interpreter.parsergenerator.syntax.builder.SyntaxBuilder;
import fri.patterns.interpreter.parsergenerator.syntax.builder.SyntaxSeparation;
import java.io.IOException;
import java.io.InputStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CondBeanParserTest {
    private static final String CHECK_EXPRESSION = "check expression";
    private static final String PARSE_FAILED = "parse failed";
    private SyntaxSeparation separation;
    private LexerBuilder builder;
    private Lexer lexer;
    private ParserTables parserTables;
    private Parser parser;
    private AbstractExpression result;
    private ParserTables tables;
    private SyntaxBuilder builder2;
    private InputStream syntaxInput;

    @Before
    public void setUp() throws SyntaxException, LexerException, Exception {
        this.syntaxInput = CondBeanParser.class.getResourceAsStream("CondBeanParser.syntax");
        this.builder2 = new SyntaxBuilder((Object)this.syntaxInput);
        this.lexer = this.builder2.getLexer();
        this.tables = new LALRParserTables(this.builder2.getParserSyntax());
        this.parser = new Parser(this.tables);
        this.parser.setLexer(this.lexer);
    }

    @Test
    public void testParser0() throws IOException {
        this.parser.setInput((Object)"1 || 1");
        Assert.assertTrue((String)PARSE_FAILED, (boolean)this.parser.parse((Semantic)new CondBeanParser()));
        this.result = (AbstractExpression)this.parser.getResult();
        Assert.assertTrue((String)CHECK_EXPRESSION, (boolean)((Boolean)this.result.evaluate()));
    }

    @Test
    public void testParser1() throws IOException {
        this.parser.setInput((Object)"!${some.existing.property} && ${some.value} == 3 || isdef(someBean) || 11");
        Assert.assertTrue((String)PARSE_FAILED, (boolean)this.parser.parse((Semantic)new CondBeanParser()));
        this.result = (AbstractExpression)this.parser.getResult();
        Assert.assertTrue((String)CHECK_EXPRESSION, (boolean)((Boolean)this.result.evaluate()));
    }

    @Test
    public void testParser2() throws IOException {
        this.parser.setInput((Object)"2 == 3");
        Assert.assertTrue((String)PARSE_FAILED, (boolean)this.parser.parse((Semantic)new CondBeanParser()));
        this.result = (AbstractExpression)this.parser.getResult();
        Assert.assertFalse((String)CHECK_EXPRESSION, (boolean)((Boolean)this.result.evaluate()));
    }

    @Test
    public void testParser3() throws IOException {
        this.parser.setInput((Object)"2==3");
        Assert.assertTrue((String)PARSE_FAILED, (boolean)this.parser.parse((Semantic)new CondBeanParser()));
        this.result = (AbstractExpression)this.parser.getResult();
        Assert.assertFalse((String)CHECK_EXPRESSION, (boolean)((Boolean)this.result.evaluate()));
    }

    @Test
    public void testParser4() throws IOException {
        this.parser.setInput((Object)"${some.value} == 3");
        Assert.assertTrue((String)PARSE_FAILED, (boolean)this.parser.parse((Semantic)new CondBeanParser()));
        this.result = (AbstractExpression)this.parser.getResult();
        Assert.assertFalse((String)CHECK_EXPRESSION, (boolean)((Boolean)this.result.evaluate()));
    }

    @Test
    public void testParser5() throws IOException {
        this.parser.setInput((Object)"!${some.existing.property} && ${some.value} == 3");
        Assert.assertTrue((String)PARSE_FAILED, (boolean)this.parser.parse((Semantic)new CondBeanParser()));
        this.result = (AbstractExpression)this.parser.getResult();
        Assert.assertFalse((String)CHECK_EXPRESSION, (boolean)((Boolean)this.result.evaluate()));
    }

    @Test
    public void testParser6() throws IOException {
        this.parser.setInput((Object)"${some.value} == 3 && !${some.existing.property}");
        Assert.assertTrue((String)PARSE_FAILED, (boolean)this.parser.parse((Semantic)new CondBeanParser()));
        this.result = (AbstractExpression)this.parser.getResult();
        Assert.assertFalse((String)CHECK_EXPRESSION, (boolean)((Boolean)this.result.evaluate()));
    }

    @Test
    public void testParser7() throws IOException {
        this.parser.setInput((Object)"3 < 2 && 2<4");
        Assert.assertTrue((String)PARSE_FAILED, (boolean)this.parser.parse((Semantic)new CondBeanParser()));
        this.result = (AbstractExpression)this.parser.getResult();
        Assert.assertFalse((String)CHECK_EXPRESSION, (boolean)((Boolean)this.result.evaluate()));
    }

    @Test
    public void testParser8() throws IOException {
        this.parser.setInput((Object)"3 < 2 || 2<4");
        Assert.assertTrue((String)PARSE_FAILED, (boolean)this.parser.parse((Semantic)new CondBeanParser()));
        this.result = (AbstractExpression)this.parser.getResult();
        Assert.assertTrue((String)CHECK_EXPRESSION, (boolean)((Boolean)this.result.evaluate()));
    }

    public SyntaxSeparation getSeparation() {
        return this.separation;
    }

    public void setSeparation(SyntaxSeparation separation) {
        this.separation = separation;
    }

    public LexerBuilder getBuilder() {
        return this.builder;
    }

    public void setBuilder(LexerBuilder builder) {
        this.builder = builder;
    }

    public Lexer getLexer() {
        return this.lexer;
    }

    public void setLexer(Lexer lexer) {
        this.lexer = lexer;
    }

    public ParserTables getParserTables() {
        return this.parserTables;
    }

    public void setParserTables(ParserTables parserTables) {
        this.parserTables = parserTables;
    }

    public Parser getParser() {
        return this.parser;
    }

    public void setParser(Parser parser) {
        this.parser = parser;
    }

    public AbstractExpression getResult() {
        return this.result;
    }

    public void setResult(AbstractExpression result) {
        this.result = result;
    }

    public ParserTables getTables() {
        return this.tables;
    }

    public void setTables(ParserTables tables) {
        this.tables = tables;
    }

    public SyntaxBuilder getBuilder2() {
        return this.builder2;
    }

    public void setBuilder2(SyntaxBuilder builder2) {
        this.builder2 = builder2;
    }

    public InputStream getSyntaxInput() {
        return this.syntaxInput;
    }

    public void setSyntaxInput(InputStream syntaxInput) {
        this.syntaxInput = syntaxInput;
    }
}

