/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.springutils.condbean;

import eu.dnetlib.springutils.condbean.PropertyFinder;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;

public class ResourcePropertyFinder
implements PropertyFinder {
    private static final Log log = LogFactory.getLog(ResourcePropertyFinder.class);
    private Resource resource;

    @Override
    public String getProperty(String name) {
        if (this.resource == null) {
            return null;
        }
        try {
            Properties props = new Properties();
            props.load(this.resource.getInputStream());
            String res = props.getProperty(name);
            if (res != null && !res.isEmpty()) {
                return res;
            }
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            log.warn((Object)"cannot open properties", (Throwable)e);
        }
        return null;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }
}

